/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class ExcellTable
extends JPanel {
    int numrows;
    int numcols;
    int auxint;
    double auxdouble;
    boolean noempties;
    boolean auxboolean;
    String auxstring = new String();
    JTable jTable1;
    private static final long serialVersionUID = 8756319557409L;

    public ExcellTable(int trows, int tcols, int portwidth, int portheight) {
        try {
            this.numrows = trows;
            this.numcols = tcols;
            this.jbInit(portwidth, portheight);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit(int viewportwidth, int viewportheight) throws Exception {
        Object[][] data = new Object[this.numrows][this.numcols];
        Object[] header = new Object[this.numcols];
        int i = 0;
        while (i < this.numcols) {
            header[i] = new Integer(i);
            ++i;
        }
        this.jTable1 = new JTable(data, header);
        this.jTable1.setCellSelectionEnabled(true);
        this.jTable1.setBackground(Color.white);
        this.jTable1.setPreferredScrollableViewportSize(new Dimension(viewportwidth, viewportheight));
        JScrollPane scrollPane = new JScrollPane(this.jTable1, 22, 32);
        int i2 = 0;
        while (i2 < this.numcols) {
            this.jTable1.getColumnModel().getColumn(i2).setMaxWidth(55);
            ++i2;
        }
        this.jTable1.setAutoResizeMode(0);
        scrollPane.getViewport().setBackground(Color.white);
        this.add((Component)scrollPane, "Center");
        this.setMaximumSize(new Dimension(viewportwidth + 40, viewportheight + 90));
        this.setBackground(Color.white);
        ExcelAdapter myAd = new ExcelAdapter(this.jTable1);
    }

    public void trimSpaces() {
        int i = 0;
        while (i < this.numrows) {
            int j = 0;
            while (j < this.numcols) {
                this.auxstring = (String)this.jTable1.getValueAt(i, j);
                if (this.auxstring != null) {
                    this.jTable1.setValueAt(this.auxstring.trim(), i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void tableSelected(boolean selected) {
        if (selected) {
            this.setBackground(new Color(200, 225, 255));
        } else {
            this.setBackground(Color.white);
        }
    }

    public void tabelEnabled(boolean theboolean) {
        this.jTable1.setEnabled(theboolean);
    }

    public void tableSetTitle(String settitle) {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), settitle, 2, 2));
    }

    public String tableValAt(int valrow, int valcol) {
        return (String)this.jTable1.getValueAt(valrow - 1, valcol - 1);
    }

    public void tableSetStringAt(String setcellvalue, int setrow, int setcol) {
        this.jTable1.setValueAt(setcellvalue, setrow - 1, setcol - 1);
    }

    public void tableSetIntAt(int setcellvalue, int setrow, int setcol) {
        this.jTable1.setValueAt(setcellvalue, setrow - 1, setcol - 1);
    }

    public boolean noEmptyCells() {
        this.noempties = true;
        int i = 0;
        while (i < this.numrows - 1) {
            int j = 0;
            while (j < this.numcols - 1) {
                this.auxstring = (String)this.jTable1.getValueAt(i + 1, j + 1);
                if (this.auxstring == null) {
                    this.noempties = false;
                } else if (this.auxstring.trim().length() == 0) {
                    this.noempties = false;
                }
                ++j;
            }
            ++i;
        }
        return this.noempties;
    }

    public boolean noEmptyHeaders() {
        this.auxboolean = true;
        int i = 0;
        while (i < this.numrows - 1) {
            this.auxstring = (String)this.jTable1.getValueAt(i + 1, 0);
            if (this.auxstring == null) {
                this.auxboolean = false;
            } else if (this.auxstring.trim().length() == 0) {
                this.auxboolean = false;
            }
            ++i;
        }
        i = 0;
        while (i < this.numcols - 1) {
            this.auxstring = (String)this.jTable1.getValueAt(0, i + 1);
            if (this.auxstring == null) {
                this.auxboolean = false;
            } else if (this.auxstring.trim().length() == 0) {
                this.auxboolean = false;
            }
            ++i;
        }
        return this.auxboolean;
    }

    public int repertoireSize() {
        this.auxint = 0;
        int i = 0;
        while (i < this.numrows - 1) {
            int j = 0;
            while (j < this.numcols - 1) {
                this.auxboolean = true;
                if (i > 0) {
                    int k = 0;
                    while (k < i) {
                        int l = 0;
                        while (l < this.numcols - 1) {
                            if (((String)this.jTable1.getValueAt(k + 1, l + 1)).equals((String)this.jTable1.getValueAt(i + 1, j + 1))) {
                                this.auxboolean = false;
                            }
                            ++l;
                        }
                        ++k;
                    }
                }
                if (j > 0) {
                    int l = 0;
                    while (l < j) {
                        if (((String)this.jTable1.getValueAt(i + 1, l + 1)).equals((String)this.jTable1.getValueAt(i + 1, j + 1))) {
                            this.auxboolean = false;
                        }
                        ++l;
                    }
                }
                if (this.auxboolean) {
                    ++this.auxint;
                }
                ++j;
            }
            ++i;
        }
        return this.auxint;
    }

    public boolean reflexive() {
        this.auxboolean = true;
        if (this.numrows != this.numcols) {
            this.auxboolean = false;
        } else {
            int i = 0;
            while (i < this.numrows - 1) {
                if (!((String)this.jTable1.getValueAt(i + 1, i + 1)).equals("1") && !((String)this.jTable1.getValueAt(i + 1, i + 1)).equals("1.0")) {
                    this.auxboolean = false;
                }
                ++i;
            }
        }
        return this.auxboolean;
    }

    public boolean symmetric() {
        this.auxboolean = true;
        if (this.numrows != this.numcols) {
            this.auxboolean = false;
        } else {
            int i = 0;
            while (i < this.numrows - 1) {
                int j = i + 1;
                while (j < this.numcols) {
                    if ((String)this.jTable1.getValueAt(i, j) == null || (String)this.jTable1.getValueAt(j, i) == null) {
                        this.auxboolean = false;
                    } else if (!((String)this.jTable1.getValueAt(i, j)).equals((String)this.jTable1.getValueAt(j, i))) {
                        this.auxboolean = false;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.auxboolean;
    }

    public boolean weighted() {
        this.auxboolean = true;
        int i = 0;
        while (i < this.numrows - 1) {
            int j = 0;
            while (j < this.numcols - 1) {
                this.auxstring = (String)this.jTable1.getValueAt(i + 1, j + 1);
                if (this.auxstring == null) {
                    this.auxboolean = false;
                } else {
                    System.out.println("number of values " + this.auxstring.split(":").length);
                    if (this.auxstring.split(":").length == 0) {
                        this.auxboolean = false;
                    } else {
                        int k = 0;
                        while (k < this.auxstring.split(":").length) {
                            try {
                                this.auxdouble = Double.parseDouble(this.auxstring.split(":")[k]);
                                System.out.println("value " + this.auxdouble);
                                if (this.auxdouble < 0.0 || this.auxdouble > 1.0) {
                                    this.auxboolean = false;
                                }
                            }
                            catch (NumberFormatException x) {
                                this.auxboolean = false;
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return this.auxboolean;
    }

    public boolean relation() {
        this.auxboolean = true;
        if (this.noEmptyCells() && this.noEmptyHeaders()) {
            if (!(this.reflexive() && this.symmetric() && this.weighted())) {
                this.auxboolean = false;
            }
        } else {
            this.auxboolean = false;
        }
        return this.auxboolean;
    }
}

