/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.math.BigDecimal;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

class ModeProcessor {
    int nodeaxis;
    int dataaxis;
    int repertoireaxis;
    boolean proceed;
    int auxint;
    int auxintk;
    boolean auxboolean;
    String auxstring;
    Dimension spacebox4 = new Dimension(40, 40);
    ExcellTable typicalData;
    ExcellTable uOptions;
    ExcellTable rOptions;
    int[][] selectFirstU;
    int[][] selectFirstR;
    int[][] uTest;
    int[][] rTest;
    int[][] dataArray;
    double[][][] uOptionsArray;
    double[][][] rOptionsArray;
    String[][] uStore;
    String[][] rStore;
    JPanel outputPanel;
    JScrollBar outputPanelBar;
    Random auxrandom = new Random();

    public ModeProcessor(ExcellTable theData, ExcellTable theUOptions, ExcellTable theROptions, JPanel thePanel, JScrollBar theScrollBar) {
        int j;
        this.typicalData = theData;
        this.uOptions = theUOptions;
        this.rOptions = theROptions;
        this.outputPanel = thePanel;
        this.outputPanelBar = theScrollBar;
        this.nodeaxis = theData.numcols;
        this.dataaxis = theData.numrows;
        this.repertoireaxis = theUOptions.numcols;
        this.selectFirstU = new int[this.repertoireaxis][this.repertoireaxis];
        this.selectFirstR = new int[this.nodeaxis][this.nodeaxis];
        int i = 0;
        while (i < this.repertoireaxis - 1) {
            j = 0;
            while (j < this.repertoireaxis - 1) {
                this.selectFirstU[i + 1][j + 1] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nodeaxis - 1) {
            j = 0;
            while (j < this.nodeaxis - 1) {
                this.selectFirstR[i + 1][j + 1] = 0;
                ++j;
            }
            ++i;
        }
    }

    public boolean composable() {
        this.auxboolean = true;
        int i = 0;
        block0: while (i < this.dataaxis - 1) {
            int j = 0;
            while (j < this.nodeaxis - 1) {
                this.auxint = 0;
                int k = 0;
                while (k < this.repertoireaxis - 1) {
                    if (this.typicalData.tableValAt(i + 2, j + 2).equals(this.uOptions.tableValAt(1, k + 2))) {
                        ++this.auxint;
                    }
                    ++k;
                }
                if (this.auxint != 1) {
                    this.auxboolean = false;
                    break block0;
                }
                ++j;
            }
            ++i;
        }
        return this.auxboolean;
    }

    private void setDataArray() {
        this.dataArray = new int[this.dataaxis][this.nodeaxis];
        int i = 0;
        while (i < this.dataaxis - 1) {
            int j = 0;
            while (j < this.nodeaxis - 1) {
                int k = 0;
                while (k < this.repertoireaxis - 1) {
                    if (this.typicalData.tableValAt(i + 2, j + 2).equals(this.uOptions.tableValAt(1, k + 2))) {
                        this.dataArray[i + 1][j + 1] = k + 1;
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void setuOptionsArray() {
        this.uOptionsArray = new double[this.repertoireaxis][this.repertoireaxis][];
        int i = 0;
        while (i < this.repertoireaxis - 1) {
            int j = 0;
            while (j < this.repertoireaxis - 1) {
                this.auxstring = this.uOptions.tableValAt(i + 2, j + 2);
                this.uOptionsArray[i + 1][j + 1] = new double[this.auxstring.split(":").length];
                int k = 0;
                while (k < this.auxstring.split(":").length) {
                    this.uOptionsArray[i + 1][j + 1][k] = Double.parseDouble(this.auxstring.split(":")[k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void setrOptionsArray() {
        this.rOptionsArray = new double[this.nodeaxis][this.nodeaxis][];
        int i = 0;
        while (i < this.nodeaxis - 1) {
            int j = 0;
            while (j < this.nodeaxis - 1) {
                this.auxstring = this.rOptions.tableValAt(i + 2, j + 2);
                this.rOptionsArray[i + 1][j + 1] = new double[this.auxstring.split(":").length];
                int k = 0;
                while (k < this.auxstring.split(":").length) {
                    this.rOptionsArray[i + 1][j + 1][k] = Double.parseDouble(this.auxstring.split(":")[k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void setranduOptionsArray(int theentriesval) {
        this.uOptionsArray = new double[this.repertoireaxis][this.repertoireaxis][1];
        int i = 0;
        while (i < this.repertoireaxis - 1) {
            this.uOptionsArray[i + 1][i + 1][0] = 1.0;
            ++i;
        }
        i = 0;
        while (i < this.repertoireaxis - 2) {
            int j = i;
            while (j < this.repertoireaxis - 2) {
                double tempranddouble;
                this.uOptionsArray[i + 1][j + 2][0] = tempranddouble = this.randomGenerater(theentriesval);
                this.uOptionsArray[j + 2][i + 1][0] = tempranddouble;
                ++j;
            }
            ++i;
        }
    }

    private void setrandrOptionsArray(int theentriesval) {
        this.rOptionsArray = new double[this.nodeaxis][this.nodeaxis][1];
        int i = 0;
        while (i < this.nodeaxis - 1) {
            this.rOptionsArray[i + 1][i + 1][0] = 1.0;
            ++i;
        }
        i = 0;
        while (i < this.nodeaxis - 2) {
            int j = i;
            while (j < this.nodeaxis - 2) {
                double tempranddouble;
                this.rOptionsArray[i + 1][j + 2][0] = tempranddouble = this.randomGenerater(theentriesval);
                this.rOptionsArray[j + 2][i + 1][0] = tempranddouble;
                ++j;
            }
            ++i;
        }
    }

    private double randomGenerater(int numberofintervals) {
        double randomdouble = 0.0;
        double intervalwidth = 0.0;
        double randomval = this.auxrandom.nextDouble();
        if (numberofintervals == -1) {
            return randomval;
        }
        intervalwidth = 1.0 / (double)numberofintervals;
        int i = 1;
        while (i < numberofintervals + 1) {
            randomdouble = ((double)i - 0.5) * intervalwidth;
            if (randomval <= (double)i * intervalwidth) break;
            ++i;
        }
        return randomdouble;
    }

    private double[][] RUSi(int dataindex, int[][] whichUoption) {
        double[][] RUSidouble = new double[this.nodeaxis][this.nodeaxis];
        int i = 0;
        while (i < this.nodeaxis - 1) {
            int j = 0;
            while (j < this.nodeaxis - 1) {
                RUSidouble[i + 1][j + 1] = this.uOptionsArray[this.dataArray[dataindex][i + 1]][this.dataArray[dataindex][j + 1]][whichUoption[this.dataArray[dataindex][i + 1]][this.dataArray[dataindex][j + 1]]];
                ++j;
            }
            ++i;
        }
        return RUSidouble;
    }

    private double[][] RT(int[][] theUoption) {
        double[][] RTdouble = new double[this.nodeaxis][this.nodeaxis];
        RTdouble = this.RUSi(1, theUoption);
        if (this.dataaxis > 2) {
            double[][] tempdouble = new double[this.nodeaxis][this.nodeaxis];
            int k = 2;
            while (k < this.dataaxis) {
                tempdouble = this.RUSi(k, theUoption);
                int i = 0;
                while (i < this.nodeaxis - 1) {
                    int j = 0;
                    while (j < this.nodeaxis - 1) {
                        RTdouble[i + 1][j + 1] = RTdouble[i + 1][j + 1] + tempdouble[i + 1][j + 1];
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
            int i = 0;
            while (i < this.nodeaxis - 1) {
                int j = 0;
                while (j < this.nodeaxis - 1) {
                    RTdouble[i + 1][j + 1] = RTdouble[i + 1][j + 1] / (double)(this.dataaxis - 1);
                    ++j;
                }
                ++i;
            }
        }
        return RTdouble;
    }

    private double dnMetric(int valueofn, int[][] whichRoption, double[][] theRUSi, boolean takenthroot) {
        double tempdouble = 0.0;
        if (valueofn > 0 && valueofn < 5) {
            int i = 0;
            while (i < this.nodeaxis - 1) {
                int j = 0;
                while (j < this.nodeaxis - 1) {
                    tempdouble += Math.pow(Math.abs(this.rOptionsArray[i + 1][j + 1][whichRoption[i + 1][j + 1]] - theRUSi[i + 1][j + 1]), valueofn);
                    ++j;
                }
                ++i;
            }
            if (takenthroot && valueofn != 1) {
                tempdouble = valueofn == 2 ? Math.sqrt(tempdouble) : (valueofn == 3 ? Math.cbrt(tempdouble) : Math.sqrt(Math.sqrt(tempdouble)));
            }
        } else if (valueofn == 100) {
            int i = 0;
            while (i < this.nodeaxis - 1) {
                int j = 0;
                while (j < this.nodeaxis - 1) {
                    tempdouble = Math.max(tempdouble, Math.abs(this.rOptionsArray[i + 1][j + 1][whichRoption[i + 1][j + 1]] - theRUSi[i + 1][j + 1]));
                    ++j;
                }
                ++i;
            }
        }
        return tempdouble;
    }

    private double dnRUT(int valueofn, int[][] theRoption, int[][] theUoption) {
        double tempdouble = 0.0;
        int i = 0;
        while (i < this.dataaxis - 1) {
            tempdouble += this.dnMetric(valueofn, theRoption, this.RUSi(i + 1, theUoption), true);
            ++i;
        }
        return tempdouble /= (double)(this.dataaxis - 1);
    }

    private boolean generateSj(int place) {
        if (place > this.nodeaxis - 1) {
            return false;
        }
        if (this.dataArray[0][place] + 1 < this.repertoireaxis) {
            this.dataArray[0][place] = this.dataArray[0][place] + 1;
            return true;
        }
        this.dataArray[0][place] = 1;
        return this.generateSj(place + 1);
    }

    private double feRUSi(int valueofn, int[][] theRoption, int[][] theUoption, int dataindex) {
        double tempdouble = 0.0;
        double dnRRUSi = this.dnMetric(valueofn, theRoption, this.RUSi(dataindex, theUoption), false);
        int i = 0;
        while (i < this.nodeaxis - 1) {
            this.dataArray[0][i + 1] = 1;
            ++i;
        }
        do {
            if (!(this.dnMetric(valueofn, theRoption, this.RUSi(0, theUoption), false) <= dnRRUSi)) continue;
            tempdouble += 1.0;
        } while (this.generateSj(1));
        tempdouble = Math.log(tempdouble) / Math.log(2.0);
        return tempdouble;
    }

    private double feRUT(int valueofn, int[][] theRoption, int[][] theUoption, boolean fast, double breakvalue) {
        int numstates = (int)Math.pow(this.repertoireaxis - 1, this.nodeaxis - 1);
        int[][] sortlist = new int[numstates][2];
        int i = 0;
        while (i < numstates) {
            sortlist[i][0] = i;
            ++i;
        }
        this.auxintk = 1;
        this.quickSort(sortlist, 0, numstates - 1, valueofn, theRoption, theUoption);
        int countint = 0;
        int remsort = sortlist[0][1];
        sortlist[0][1] = numstates;
        int i2 = 1;
        while (i2 < numstates) {
            if (sortlist[i2][1] != remsort) {
                countint = i2;
                remsort = sortlist[i2][1];
            }
            sortlist[i2][1] = numstates - countint;
            ++i2;
        }
        countint = 0;
        while (countint < numstates - 1) {
            if (sortlist[countint][0] != countint) {
                int swapa = sortlist[sortlist[countint][0]][0];
                int swapb = sortlist[sortlist[countint][0]][1];
                sortlist[sortlist[countint][0]][0] = sortlist[countint][0];
                sortlist[sortlist[countint][0]][1] = sortlist[countint][1];
                sortlist[countint][0] = swapa;
                sortlist[countint][1] = swapb;
                continue;
            }
            ++countint;
        }
        double tempdouble = 0.0;
        BigDecimal tempBigDec = new BigDecimal("0");
        if (fast) {
            int tempint = 0;
            while (tempint < this.dataaxis - 1 && tempdouble <= breakvalue) {
                tempBigDec = tempBigDec.add(BigDecimal.valueOf(Math.log(sortlist[this.tindextoindex(tempint + 1)][1]) / Math.log(2.0)));
                tempdouble = tempBigDec.doubleValue();
                ++tempint;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dataaxis - 1) {
                tempBigDec = tempBigDec.add(BigDecimal.valueOf(Math.log(sortlist[this.tindextoindex(i3 + 1)][1]) / Math.log(2.0)));
                ++i3;
            }
            tempdouble = tempBigDec.doubleValue();
            tempdouble /= (double)(this.dataaxis - 1);
        }
        return tempdouble;
    }

    private void indextostate(int indexint) {
        double tempdouble = indexint;
        int i = this.nodeaxis - 1;
        while (i > 0) {
            int tempint = (int)(tempdouble / Math.pow(this.repertoireaxis - 1, i - 1));
            this.dataArray[0][i] = tempint + 1;
            tempdouble -= (double)tempint * Math.pow(this.repertoireaxis - 1, i - 1);
            --i;
        }
    }

    private int tindextoindex(int tindexint) {
        int tempint = 0;
        int i = this.nodeaxis - 1;
        while (i > 0) {
            tempint += (this.dataArray[tindexint][i] - 1) * (int)Math.pow(this.repertoireaxis - 1, i - 1);
            --i;
        }
        return tempint;
    }

    private void quickSort(int[][] arr, int begin, int end, int valueofn, int[][] theRoption, int[][] theUoption) {
        if (begin < end) {
            int[] partitionIndex = this.partition(arr, begin, end, valueofn, theRoption, theUoption);
            ++this.auxintk;
            this.quickSort(arr, begin, partitionIndex[0], valueofn, theRoption, theUoption);
            ++this.auxintk;
            this.quickSort(arr, partitionIndex[1], end, valueofn, theRoption, theUoption);
        }
    }

    private int[] partition(int[][] arr, int begin, int end, int valueofn, int[][] theRoption, int[][] theUoption) {
        this.indextostate(arr[(end + begin) / 2][0]);
        double pivot = this.dnMetric(valueofn, theRoption, this.RUSi(0, theUoption), false);
        int i = begin - 1;
        int k = end + 1;
        int j = begin;
        while (j < end + 1) {
            int swapTempone;
            this.indextostate(arr[j][0]);
            double dnmetatj = this.dnMetric(valueofn, theRoption, this.RUSi(0, theUoption), false);
            if (dnmetatj > pivot || arr[j][1] > 0) {
                swapTempone = arr[++i][0];
                int swapTemptwo = arr[i][1];
                arr[i][0] = arr[j][0];
                arr[i][1] = arr[j][1];
                arr[j][0] = swapTempone;
                arr[j][1] = swapTemptwo;
            } else if (dnmetatj == pivot) {
                swapTempone = arr[--k][0];
                arr[k][0] = arr[j][0];
                arr[j][0] = swapTempone;
                arr[j][1] = arr[k][1];
                arr[k][1] = this.auxintk;
                --j;
            }
            ++j;
        }
        int[] parindex = new int[]{i - (end + 1 - k), i + 1};
        return parindex;
    }

    private double approximateUR(int valueofn, int radiobuttonr, int radiobuttonu) {
        int j;
        this.rStore = new String[this.nodeaxis][this.nodeaxis];
        this.uStore = new String[this.repertoireaxis][this.repertoireaxis];
        this.rTest = new int[this.nodeaxis][this.nodeaxis];
        this.uTest = new int[this.repertoireaxis][this.repertoireaxis];
        int i = 0;
        while (i < this.nodeaxis - 1) {
            j = 0;
            while (j < this.nodeaxis - 1) {
                this.rTest[i + 1][j + 1] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.repertoireaxis - 1) {
            j = 0;
            while (j < this.repertoireaxis - 1) {
                this.uTest[i + 1][j + 1] = 0;
                ++j;
            }
            ++i;
        }
        double febar = this.feRUT(valueofn, this.rTest, this.uTest, false, 1.0);
        febar = febar * (double)(this.dataaxis - 1) + 100.0;
        int proxint = 0;
        boolean proxboolean = false;
        int iforr = 1;
        int jforr = 2;
        int bestkforr = -1;
        double bestforr = 1.0;
        int iforu = 1;
        int jforu = 2;
        int bestkforu = -1;
        double bestforu = 1.0;
        do {
            int j2;
            double proxdouble;
            if ((proxdouble = this.feRUT(valueofn, this.rTest, this.uTest, true, febar)) < febar) {
                int i2 = 0;
                while (i2 < this.nodeaxis - 1) {
                    j2 = 0;
                    while (j2 < this.nodeaxis - 1) {
                        this.rStore[i2 + 1][j2 + 1] = Double.toString(this.rOptionsArray[i2 + 1][j2 + 1][this.rTest[i2 + 1][j2 + 1]]);
                        ++j2;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.repertoireaxis - 1) {
                    j2 = 0;
                    while (j2 < this.repertoireaxis - 1) {
                        this.uStore[i2 + 1][j2 + 1] = Double.toString(this.uOptionsArray[i2 + 1][j2 + 1][this.uTest[i2 + 1][j2 + 1]]);
                        ++j2;
                    }
                    ++i2;
                }
                febar = proxdouble;
                proxint = 0;
            } else if (proxdouble == febar && proxint < 10) {
                int i3 = 0;
                while (i3 < this.nodeaxis - 1) {
                    j2 = 0;
                    while (j2 < this.nodeaxis - 1) {
                        this.rStore[i3 + 1][j2 + 1] = String.valueOf(this.rStore[i3 + 1][j2 + 1]) + ":" + this.rOptionsArray[i3 + 1][j2 + 1][this.rTest[i3 + 1][j2 + 1]];
                        ++j2;
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < this.repertoireaxis - 1) {
                    j2 = 0;
                    while (j2 < this.repertoireaxis - 1) {
                        this.uStore[i3 + 1][j2 + 1] = String.valueOf(this.uStore[i3 + 1][j2 + 1]) + ":" + this.uOptionsArray[i3 + 1][j2 + 1][this.uTest[i3 + 1][j2 + 1]];
                        ++j2;
                    }
                    ++i3;
                }
                ++proxint;
            }
            if (!this.proceed) break;
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            switch (radiobuttonr) {
                case 1: {
                    proxboolean = this.generatorOneForR(1, 2);
                    break;
                }
                case 2: {
                    proxboolean = this.generatorTwoForR();
                    break;
                }
                case 3: {
                    proxboolean = false;
                    if (this.nodeaxis <= 2) break;
                    proxboolean = true;
                    if (proxdouble < bestforr || bestkforr == -1) {
                        bestforr = proxdouble;
                        bestkforr = this.rTest[iforr][jforr];
                    }
                    if (this.rTest[iforr][jforr] + 1 < this.rOptionsArray[iforr][jforr].length) {
                        this.rTest[iforr][jforr] = this.rTest[iforr][jforr] + 1;
                        this.rTest[jforr][iforr] = this.rTest[jforr][iforr] + 1;
                        break;
                    }
                    this.rTest[iforr][jforr] = bestkforr;
                    this.rTest[jforr][iforr] = bestkforr;
                    do {
                        if (jforr + 1 < this.nodeaxis) {
                            if (this.rOptionsArray[iforr][++jforr].length <= 1) continue;
                            bestkforr = 0;
                            this.rTest[iforr][jforr] = 1;
                            this.rTest[jforr][iforr] = 1;
                            continue;
                        }
                        if (iforr + 1 < this.nodeaxis - 1) {
                            if (this.rOptionsArray[++iforr][jforr = iforr + 1].length <= 1) continue;
                            bestkforr = 0;
                            this.rTest[iforr][jforr] = 1;
                            this.rTest[jforr][iforr] = 1;
                            continue;
                        }
                        iforr = 1;
                        jforr = 2;
                        int i4 = 0;
                        while (i4 < this.nodeaxis - 1) {
                            j2 = 0;
                            while (j2 < this.nodeaxis - 1) {
                                this.rTest[i4 + 1][j2 + 1] = 0;
                                ++j2;
                            }
                            ++i4;
                        }
                        bestkforr = -1;
                        proxboolean = false;
                    } while (this.rOptionsArray[iforr][jforr].length < 2 && proxboolean);
                }
            }
            if (proxboolean) continue;
            switch (radiobuttonu) {
                case 1: {
                    proxboolean = this.generatorOneForU(1, 2);
                    break;
                }
                case 2: {
                    proxboolean = this.generatorTwoForU();
                    break;
                }
                case 3: {
                    proxboolean = false;
                    if (this.repertoireaxis <= 2) break;
                    proxboolean = true;
                    if (proxdouble < bestforu || bestkforu == -1) {
                        bestforu = proxdouble;
                        bestkforu = this.uTest[iforu][jforu];
                    }
                    if (this.uTest[iforu][jforu] + 1 < this.uOptionsArray[iforu][jforu].length) {
                        this.uTest[iforu][jforu] = this.uTest[iforu][jforu] + 1;
                        this.uTest[jforu][iforu] = this.uTest[jforu][iforu] + 1;
                        break;
                    }
                    this.uTest[iforu][jforu] = bestkforu;
                    this.uTest[jforu][iforu] = bestkforu;
                    do {
                        if (jforu + 1 < this.repertoireaxis) {
                            if (this.uOptionsArray[iforu][++jforu].length <= 1) continue;
                            bestkforu = 0;
                            this.uTest[iforu][jforu] = 1;
                            this.uTest[jforu][iforu] = 1;
                            continue;
                        }
                        if (iforu + 1 < this.repertoireaxis - 1) {
                            if (this.uOptionsArray[++iforu][jforu = iforu + 1].length <= 1) continue;
                            bestkforu = 0;
                            this.uTest[iforu][jforu] = 1;
                            this.uTest[jforu][iforu] = 1;
                            continue;
                        }
                        proxboolean = false;
                    } while (this.uOptionsArray[iforu][jforu].length < 2 && proxboolean);
                }
            }
        } while (proxboolean);
        return febar /= (double)(this.dataaxis - 1);
    }

    private boolean generatorOneForR(int iplace, int jplace) {
        if (iplace > this.nodeaxis - 2) {
            return false;
        }
        if (jplace > this.nodeaxis - 1) {
            return this.generatorOneForR(iplace + 1, iplace + 2);
        }
        if (this.rTest[iplace][jplace] + 1 > this.rOptionsArray[iplace][jplace].length - 1) {
            this.rTest[iplace][jplace] = 0;
            this.rTest[jplace][iplace] = 0;
            return this.generatorOneForR(iplace, jplace + 1);
        }
        this.rTest[iplace][jplace] = this.rTest[iplace][jplace] + 1;
        this.rTest[jplace][iplace] = this.rTest[jplace][iplace] + 1;
        return true;
    }

    private boolean generatorOneForU(int iplace, int jplace) {
        if (iplace > this.repertoireaxis - 2) {
            return false;
        }
        if (jplace > this.repertoireaxis - 1) {
            return this.generatorOneForU(iplace + 1, iplace + 2);
        }
        if (this.uTest[iplace][jplace] + 1 > this.uOptionsArray[iplace][jplace].length - 1) {
            this.uTest[iplace][jplace] = 0;
            this.uTest[jplace][iplace] = 0;
            return this.generatorOneForU(iplace, jplace + 1);
        }
        this.uTest[iplace][jplace] = this.uTest[iplace][jplace] + 1;
        this.uTest[jplace][iplace] = this.uTest[jplace][iplace] + 1;
        return true;
    }

    private boolean generatorTwoForR() {
        int j;
        boolean proxbooleantwo = false;
        int i = 1;
        while (i < this.nodeaxis - 1) {
            j = i + 1;
            while (j < this.nodeaxis) {
                if (this.rTest[i][j] + 1 < this.rOptionsArray[i][j].length) {
                    this.rTest[i][j] = this.rTest[i][j] + 1;
                    this.rTest[j][i] = this.rTest[j][i] + 1;
                    proxbooleantwo = true;
                }
                ++j;
            }
            ++i;
        }
        if (!proxbooleantwo) {
            i = 0;
            while (i < this.nodeaxis - 1) {
                j = 0;
                while (j < this.nodeaxis - 1) {
                    this.rTest[i + 1][j + 1] = 0;
                    ++j;
                }
                ++i;
            }
        }
        return proxbooleantwo;
    }

    private boolean generatorTwoForU() {
        int j;
        boolean proxbooleantwo = false;
        int i = 1;
        while (i < this.repertoireaxis - 1) {
            j = i + 1;
            while (j < this.repertoireaxis) {
                if (this.uTest[i][j] + 1 < this.uOptionsArray[i][j].length) {
                    this.uTest[i][j] = this.uTest[i][j] + 1;
                    this.uTest[j][i] = this.uTest[j][i] + 1;
                    proxbooleantwo = true;
                }
                ++j;
            }
            ++i;
        }
        if (!proxbooleantwo) {
            i = 0;
            while (i < this.repertoireaxis - 1) {
                j = 0;
                while (j < this.repertoireaxis - 1) {
                    this.uTest[i + 1][j + 1] = 0;
                    ++j;
                }
                ++i;
            }
        }
        return proxbooleantwo;
    }

    private double[][] feRUTrandomvariable(int thevalofn, int obsval, int entriesval) {
        double[][] eferanddouble = new double[obsval + 1][2];
        int i = 0;
        while (i < obsval) {
            this.setranduOptionsArray(entriesval);
            this.setrandrOptionsArray(entriesval);
            if (!this.proceed) break;
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            eferanddouble[i + 1][1] = this.feRUT(thevalofn, this.selectFirstR, this.selectFirstU, false, 0.0);
            ++i;
        }
        return eferanddouble;
    }

    private Object[][] toObjectArray(double[][] thearray) {
        Object[][] convertedarray = new Object[thearray.length][thearray[0].length];
        int i = 0;
        while (i < thearray.length - 1) {
            int j = 0;
            while (j < thearray[0].length - 1) {
                convertedarray[i + 1][j + 1] = Double.toString((double)Math.round(thearray[i + 1][j + 1] * 1000000.0) / 1000000.0);
                ++j;
            }
            ++i;
        }
        return convertedarray;
    }

    private Object[][] toObjectArrayNoRounding(double[][] thearray) {
        Object[][] convertedarray = new Object[thearray.length][thearray[0].length];
        int i = 0;
        while (i < thearray.length - 1) {
            int j = 0;
            while (j < thearray[0].length - 1) {
                convertedarray[i + 1][j + 1] = Double.toString(thearray[i + 1][j + 1]);
                ++j;
            }
            ++i;
        }
        return convertedarray;
    }

    private Object[][] addnodeheaders(Object[][] thearray) {
        int i = 0;
        while (i < thearray.length - 1) {
            thearray[0][i + 1] = "node " + (i + 1);
            thearray[i + 1][0] = "node " + (i + 1);
            ++i;
        }
        return thearray;
    }

    private Object[][] addrepertoireheaders(Object[][] thearray) {
        if (thearray.length == thearray[0].length && thearray.length == this.repertoireaxis) {
            int i = 0;
            while (i < this.repertoireaxis - 1) {
                thearray[0][i + 1] = this.uOptions.tableValAt(1, i + 2);
                thearray[i + 1][0] = this.uOptions.tableValAt(i + 2, 1);
                ++i;
            }
        }
        return thearray;
    }

    private Object[][] addheadernumbers(Object[][] thearray) {
        int i = 0;
        while (i < thearray[0].length - 1) {
            thearray[0][i + 1] = "" + (i + 1);
            ++i;
        }
        i = 0;
        while (i < thearray.length - 1) {
            thearray[i + 1][0] = "" + (i + 1);
            ++i;
        }
        return thearray;
    }

    private Object[][] addthetypicaldata(Object[][] thearray) {
        if (thearray.length == this.dataaxis && thearray[0].length == this.nodeaxis + 1) {
            int i = 0;
            while (i < this.dataaxis) {
                int j = 0;
                while (j < this.nodeaxis) {
                    thearray[i][j] = this.typicalData.tableValAt(i + 1, j + 1);
                    ++j;
                }
                ++i;
            }
            thearray[0][this.nodeaxis] = "fe";
        }
        return thearray;
    }

    private double[][] threeDtotwoD(double[][][] thethreedarray) {
        double[][] thetwodarray = new double[thethreedarray.length][thethreedarray[0].length];
        int i = 0;
        while (i < thethreedarray.length) {
            int j = 0;
            while (j < thethreedarray[0].length) {
                thetwodarray[i][j] = thethreedarray[i][j][0];
                ++j;
            }
            ++i;
        }
        return thetwodarray;
    }

    private double[][] feRUSiforalli(int thevalofn, int[][] theRoptionin, int[][] theUoptionin) {
        double[][] efdatadouble = new double[this.dataaxis][this.nodeaxis + 1];
        int i = 0;
        while (i < this.dataaxis - 1) {
            if (!this.proceed) break;
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            efdatadouble[i + 1][this.nodeaxis] = this.feRUSi(thevalofn, theRoptionin, theUoptionin, i + 1);
            ++i;
        }
        return efdatadouble;
    }

    public void modeOne(int thedataindex) {
        this.setDataArray();
        if (this.proceed) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setuOptionsArray();
            if (this.proceed) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                this.outputPanel.add(new ExcellOutputTable(this.addnodeheaders(this.toObjectArray(this.RUSi(thedataindex, this.selectFirstU))), 440, 385, "R(U_op1,S_" + thedataindex + ")"));
                this.outputPanel.getParent().validate();
                this.outputPanel.getParent().repaint();
                this.outputPanelBar.setValue(this.outputPanelBar.getMaximum());
            }
        }
    }

    public void modeTwo() {
        this.setDataArray();
        if (this.proceed) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setuOptionsArray();
            if (this.proceed) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                this.outputPanel.add(new ExcellOutputTable(this.addnodeheaders(this.toObjectArray(this.RT(this.selectFirstU))), 440, 385, "R_T"));
                this.outputPanel.getParent().validate();
                this.outputPanel.getParent().repaint();
                this.outputPanelBar.setValue(this.outputPanelBar.getMaximum());
            }
        }
    }

    public void modeThree(int thedataindex, int thevalueofn) {
        this.setDataArray();
        if (this.proceed) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setuOptionsArray();
            if (this.proceed) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.setrOptionsArray();
                if (this.proceed) {
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                    if (thevalueofn == 100) {
                        this.outputPanel.add(new centerJLabel("fe(R_op1,U_op1,S_" + thedataindex + ")=" + this.feRUSi(thevalueofn, this.selectFirstR, this.selectFirstU, thedataindex) + " for d_n with n=infinity"));
                    } else {
                        this.outputPanel.add(new centerJLabel("fe(R_op1,U_op1,S_" + thedataindex + ")=" + this.feRUSi(thevalueofn, this.selectFirstR, this.selectFirstU, thedataindex) + " for d_n with n=" + thevalueofn));
                    }
                    this.outputPanel.getParent().validate();
                    this.outputPanel.getParent().repaint();
                    this.outputPanelBar.setValue(this.outputPanelBar.getMaximum());
                }
            }
        }
    }

    public void modeFour(int thevalueofn) {
        this.setDataArray();
        if (this.proceed) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setuOptionsArray();
            if (this.proceed) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.setrOptionsArray();
                if (this.proceed) {
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                    if (thevalueofn == 100) {
                        this.outputPanel.add(new centerJLabel("efe(R_op1,U_op1,T)=" + this.feRUT(thevalueofn, this.selectFirstR, this.selectFirstU, false, 0.0) + " for d_n with n=infinity"));
                    } else {
                        this.outputPanel.add(new centerJLabel("efe(R_op1,U_op1,T)=" + this.feRUT(thevalueofn, this.selectFirstR, this.selectFirstU, false, 0.0) + " for d_n with n=" + thevalueofn));
                    }
                    this.outputPanel.getParent().validate();
                    this.outputPanel.getParent().repaint();
                    this.outputPanelBar.setValue(this.outputPanelBar.getMaximum());
                }
            }
        }
    }

    public void modeFive(int thedataindex, int thevalueofn) {
        this.setDataArray();
        if (this.proceed) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setuOptionsArray();
            if (this.proceed) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.setrOptionsArray();
                if (this.proceed) {
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                    if (thevalueofn == 100) {
                        this.outputPanel.add(new centerJLabel("d_infinity(R_op1,R(U_op1,S_" + thedataindex + "))=" + this.dnMetric(thevalueofn, this.selectFirstR, this.RUSi(thedataindex, this.selectFirstU), true)));
                    } else {
                        this.outputPanel.add(new centerJLabel("d_" + thevalueofn + "(R_op1,R(U_op1,S_" + thedataindex + "))=" + this.dnMetric(thevalueofn, this.selectFirstR, this.RUSi(thedataindex, this.selectFirstU), true)));
                    }
                    this.outputPanel.getParent().validate();
                    this.outputPanel.getParent().repaint();
                    this.outputPanelBar.setValue(this.outputPanelBar.getMaximum());
                }
            }
        }
    }

    public void modeSix(int thevanueofn) {
        this.setDataArray();
        if (this.proceed) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setuOptionsArray();
            if (this.proceed) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.setrOptionsArray();
                if (this.proceed) {
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                    if (thevanueofn == 100) {
                        this.outputPanel.add(new centerJLabel("d_infinity(R_op1,U_op1,T)=" + this.dnRUT(thevanueofn, this.selectFirstR, this.selectFirstU)));
                    } else {
                        this.outputPanel.add(new centerJLabel("d_" + thevanueofn + "(R_op1,U_op1,T)=" + this.dnRUT(thevanueofn, this.selectFirstR, this.selectFirstU)));
                    }
                    this.outputPanel.getParent().validate();
                    this.outputPanel.getParent().repaint();
                    this.outputPanelBar.setValue(this.outputPanelBar.getMaximum());
                }
            }
        }
    }

    public void modeSeven(int thevalueofn, int radiobuttonr, int radiobuttonu) {
        this.setDataArray();
        if (this.proceed) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setuOptionsArray();
            if (this.proceed) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.setrOptionsArray();
                if (this.proceed) {
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                    this.outputPanel.add(new centerJLabel("------------- Approximation of U and R -------------"));
                    this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                    if (thevalueofn == 100) {
                        this.outputPanel.add(new centerJLabel("efe(R_approx,U_approx,T)=" + this.approximateUR(thevalueofn, radiobuttonr, radiobuttonu) + " for d_n with n=infinity"));
                    } else {
                        this.outputPanel.add(new centerJLabel("efe(R_approx,U_approx,T)=" + this.approximateUR(thevalueofn, radiobuttonr, radiobuttonu) + " for d_n with n=" + thevalueofn));
                    }
                    this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                    this.outputPanel.add(new ExcellOutputTable(this.addrepertoireheaders(this.uStore), 440, 385, "Approximations of U"));
                    this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                    this.outputPanel.add(new ExcellOutputTable(this.addnodeheaders(this.rStore), 440, 385, "Approximations of R"));
                    this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                    this.outputPanel.add(new centerJLabel("---------------------------------------------------------------------------"));
                    this.outputPanel.getParent().validate();
                    this.outputPanel.getParent().repaint();
                    this.outputPanelBar.setValue(this.outputPanelBar.getMaximum());
                }
            }
        }
    }

    public void modeEight(int thevalueofn, int observsvalue, int entriesresvalue) {
        this.setDataArray();
        if (this.proceed) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
            this.outputPanel.add(new centerJLabel(String.valueOf(observsvalue) + " observations of efe(R_random,U_random,T) with"));
            if (entriesresvalue == -1) {
                this.outputPanel.add(new centerJLabel("each entry in R_random and U_random a random double in [0,1),"));
            } else {
                this.outputPanel.add(new centerJLabel(String.valueOf(entriesresvalue) + " possibilities per entry in R_random and U_random,"));
            }
            if (thevalueofn == 100) {
                this.outputPanel.add(new centerJLabel("and d_n with n=infinity"));
            } else {
                this.outputPanel.add(new centerJLabel("and d_n with n=" + thevalueofn));
            }
            this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
            this.outputPanel.add(new ExcellOutputTable(this.addheadernumbers(this.toObjectArrayNoRounding(this.feRUTrandomvariable(thevalueofn, observsvalue, entriesresvalue))), 440, 385, "efe(R_random,U_random,T)"));
            this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
            this.outputPanel.add(new ExcellOutputTable(this.addrepertoireheaders(this.toObjectArrayNoRounding(this.threeDtotwoD(this.uOptionsArray))), 440, 385, "Example of U_random"));
            this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
            this.outputPanel.add(new ExcellOutputTable(this.addnodeheaders(this.toObjectArrayNoRounding(this.threeDtotwoD(this.rOptionsArray))), 440, 385, "Example of R_random"));
            this.outputPanel.getParent().validate();
            this.outputPanel.getParent().repaint();
            this.outputPanelBar.setValue(this.outputPanelBar.getMaximum());
        }
    }

    public void modeNine(int thevalueofn) {
        this.setDataArray();
        if (this.proceed) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setuOptionsArray();
            if (this.proceed) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.setrOptionsArray();
                if (this.proceed) {
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                    if (thevalueofn == 100) {
                        this.outputPanel.add(new centerJLabel("fe(R_op1,U_op1,S_i) for all i and for d_n with n=infinity"));
                    } else {
                        this.outputPanel.add(new centerJLabel("fe(R_op1,U_op1,S_i) for all i and for d_n with n=" + thevalueofn));
                    }
                    this.outputPanel.add(new Box.Filler(this.spacebox4, this.spacebox4, this.spacebox4));
                    this.outputPanel.add(new ExcellOutputTable(this.addthetypicaldata(this.toObjectArrayNoRounding(this.feRUSiforalli(thevalueofn, this.selectFirstR, this.selectFirstU))), 440, 385, "fe(R_op1,U_op1,S_i)"));
                    this.outputPanel.getParent().validate();
                    this.outputPanel.getParent().repaint();
                    this.outputPanelBar.setValue(this.outputPanelBar.getMaximum());
                }
            }
        }
    }
}

