import java.awt.*;
import javax.swing.*;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import java.io.IOException;
import java.net.MalformedURLException;

class Dialogtype1
{
	public Dialogtype1(JFrame parentframe, String openingpage, String titletext)
	{
		JEditorPane edit = new JEditorPane();
		Hyperactive uselinks = new Hyperactive();
		edit.setEditable(false);
		edit.addHyperlinkListener(uselinks);
		try {
			edit.setPage(Dialogtype1.class.getResource(openingpage));
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		JScrollPane editorScrollPane = new JScrollPane(edit);
		editorScrollPane.setPreferredSize(new Dimension(250, 145));
		JDialog mydialog = new JDialog(parentframe , titletext, Dialog.ModalityType.DOCUMENT_MODAL);
		mydialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		mydialog.add(editorScrollPane);
		mydialog.setSize(800,600);
		mydialog.setLocationRelativeTo(null);
		mydialog.setVisible(true);
	}
}

class Hyperactive implements HyperlinkListener 
{
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane) e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent  evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    pane.setPage(e.getURL());
                } catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}