import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.Toolkit;
import java.util.Random;
import java.math.BigDecimal;
import javax.swing.*;
import javax.swing.border.TitledBorder;
public class URFinderDev3 {
	public static void main(String args[])
	{
	Frame1 myframe=new Frame1();
	myframe.setVisible(true);
	}
}

class Frame1 extends JFrame implements ActionListener
{
	int stage;
	int mode;
	int qtydelements;
	int qtynodes;
	int qtynoderepertoire;
	boolean allowable;
	protected JButton stop;
	protected JButton select;
	protected JButton help;
	protected JButton progress;
	JRadioButton allucombinations;
	JRadioButton urespectively;
	JRadioButton uperturbations;
	JRadioButton allrcombinations;
	JRadioButton rrespectively;
	JRadioButton rperturbations;
	JPanel mainPanel = new JPanel();
	JScrollBar mainverticalBar;
	Dimension spacebox1 = new Dimension(40, 40);
	Dimension spacebox2 = new Dimension(3, 3);
	Dimension spacebox3 = new Dimension(15, 15);
	Color skyblue = new Color(200,225,255);
	JTextField qtynodesField = new JTextField(4);
	JTextField qtydelementsField = new JTextField(4);
	JTextField delementField = new JTextField(4);
	JTextField dnmetricField = new JTextField(4);
	JTextField observationsField = new JTextField(4);
	JTextField entriesresField = new JTextField(4);
	TextPlate modeText1;
	TextPlate modeText2;
	TextPlate modeText3;
	TextPlate modeText4;
	TextPlate modeText5;
	TextPlate modeText6;
	TextPlate modeText7;
	TextPlate modeText8;
	TextPlate modeText9;
	ExcellTable typicaldataTable;
	ExcellTable uoptionsTable;
	ExcellTable roptionsTable;
	ModeProcessor modeProcessor1;
	ProcessingThread prothread;
	private static final long serialVersionUID = 2759846310973L;
	public Frame1()
	{
		stop = new JButton("Stop");
		stop.setActionCommand("halt");
		stop.setEnabled(false);
		select = new JButton("Select");
		select.setActionCommand("selectmode");
		select.setEnabled(false);
		help = new JButton("Help");
		help.setActionCommand("helpdialog");
		progress = new JButton("Progress");
		progress.setActionCommand("next");
		JLabel toptext = new JLabel(" Choose allowable settings before progressing");
		JPanel topPanel = new JPanel();
		topPanel.setLayout(new BoxLayout(topPanel, BoxLayout.X_AXIS));
		topPanel.setBackground(skyblue);
		topPanel.setMaximumSize(new Dimension(2000, 200));
		topPanel.add(new Box.Filler(spacebox2, spacebox2, spacebox2));
		topPanel.add(stop);
		topPanel.add(new Box.Filler(spacebox2, spacebox2, spacebox2));
		topPanel.add(select);
		topPanel.add(new Box.Filler(spacebox2, spacebox2, spacebox2));
		topPanel.add(help);
		topPanel.add(new Box.Filler(spacebox2, spacebox2, spacebox2));
		topPanel.add(progress);
		topPanel.add(toptext);
		topPanel.add(Box.createHorizontalGlue());
		stop.addActionListener(this);
		select.addActionListener(this);
		help.addActionListener(this);
		progress.addActionListener(this);
		ImageIcon starticon = new ImageIcon(URFinderDev3.class.getResource("URFinderImage_1.png"));
		JLabel startimage = new JLabel("", starticon, JLabel.CENTER);
		startimage.setAlignmentX(Component.CENTER_ALIGNMENT);
		mainPanel.setBackground(Color.white);
        mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
        mainPanel.add(startimage);
        mainPanel.add(new centerJLabel("Click Progress to start."));
        JScrollPane mainscrollPane = new JScrollPane(mainPanel, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        mainverticalBar = mainscrollPane.getVerticalScrollBar();
        mainverticalBar.setUnitIncrement(25);
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.setLayout(new BoxLayout(this.getContentPane(), BoxLayout.Y_AXIS));
        this.setSize(new Dimension(650, 650));
        this.setLocationRelativeTo(null);
        this.setTitle("URFinder");
        this.add(topPanel);
        this.add(mainscrollPane);
        this.getContentPane().validate();
        this.getContentPane().repaint();
	}
	public void actionPerformed(ActionEvent e) 
	{
		if ("next".equals(e.getActionCommand()))
		{
			System.out.println("Stage "+stage);
			if (stage==0)
			{
				stageOne();
			}
			if (stage==1)
			{
				stageTwo();
			}
			if (stage==2)
			{
				stageThree();
			}
			if (stage==3)
			{
				stageFour();
			}
			if (stage==4)
			{
				stageFive();
			}
			if (allowable==true)
			{
				stage++;
			}
			allowable=false;
	    }
		if ("helpdialog".equals(e.getActionCommand()))
		{
			@SuppressWarnings("unused")
			Dialogtype1 helpdialog=new Dialogtype1(this , "HelpPage1.html", "URFinder Help");
		}
		if ("selectmode".equals(e.getActionCommand()))
		{
			mode++;
			if (mode>9)
			{
				mode=1;
			}
			if (mode==1)
			{
				typicaldataTable.tableSelected(true);
				uoptionsTable.tableSelected(true);
				roptionsTable.tableSelected(false);
				delementField.setBackground(skyblue);
				dnmetricField.setBackground(Color.white);
				observationsField.setBackground(Color.white);
				entriesresField.setBackground(Color.white);
				modeText9.setBackground(Color.white);
				modeText1.setBackground(skyblue);
			}
			if (mode==2)
			{
				delementField.setBackground(Color.white);
				modeText1.setBackground(Color.white);
				modeText2.setBackground(skyblue);
			}
			if (mode==3)
			{
				roptionsTable.tableSelected(true);
				delementField.setBackground(skyblue);
				dnmetricField.setBackground(skyblue);
				modeText2.setBackground(Color.white);
				modeText3.setBackground(skyblue);
			}
			if (mode==4)
			{
				delementField.setBackground(Color.white);
				modeText3.setBackground(Color.white);
				modeText4.setBackground(skyblue);
			}
			if (mode==5)
			{
				delementField.setBackground(skyblue);
				modeText4.setBackground(Color.white);
				modeText5.setBackground(skyblue);
			}
			if (mode==6)
			{
				delementField.setBackground(Color.white);
				modeText5.setBackground(Color.white);
				modeText6.setBackground(skyblue);
			}
			if (mode==7)
			{
				allucombinations.setBackground(skyblue);
				urespectively.setBackground(skyblue);
				uperturbations.setBackground(skyblue);
				allrcombinations.setBackground(skyblue);
				rrespectively.setBackground(skyblue);
				rperturbations.setBackground(skyblue);
				modeText6.setBackground(Color.white);
				modeText7.setBackground(skyblue);
				System.out.println("All U combinations "+allucombinations.isSelected());
				System.out.println("All R combinations "+allrcombinations.isSelected());
			}
			if (mode==8)
			{
				uoptionsTable.tableSelected(false);
				roptionsTable.tableSelected(false);
				observationsField.setBackground(skyblue);
				entriesresField.setBackground(skyblue);
				allucombinations.setBackground(Color.white);
				urespectively.setBackground(Color.white);
				uperturbations.setBackground(Color.white);
				allrcombinations.setBackground(Color.white);
				rrespectively.setBackground(Color.white);
				rperturbations.setBackground(Color.white);
				modeText7.setBackground(Color.white);
				modeText8.setBackground(skyblue);
			}
			if (mode==9)
			{
				roptionsTable.tableSelected(true);
				uoptionsTable.tableSelected(true);
				observationsField.setBackground(Color.white);
				entriesresField.setBackground(Color.white);
				modeText8.setBackground(Color.white);
				modeText9.setBackground(skyblue);
			}
		}
		if ("halt".equals(e.getActionCommand()))
		{
			modeProcessor1.proceed=false;
			stop.setEnabled(false);
		}
	}
	private void stageOne()
	{
		JPanel stageonePanel = new JPanel();
		stageonePanel.setBackground(Color.white);
		stageonePanel.setMaximumSize(new Dimension(2000, 400));
		stageonePanel.add(new JLabel("Set the number of nodes "));
		stageonePanel.add(qtynodesField);
		stageonePanel.add(new JLabel("Set the number of data elements "));
		stageonePanel.add(qtydelementsField);
		mainPanel.add(new Box.Filler(spacebox1, spacebox1, spacebox1));
		mainPanel.add(new centerJLabel("Stage 1"));
		mainPanel.add(stageonePanel);
		this.getContentPane().validate();
        this.getContentPane().repaint();
		allowable=true;
	}
	private void stageTwo()
	{
		try 
		{
			qtydelements=Integer.parseInt(qtydelementsField.getText());
			qtynodes=Integer.parseInt(qtynodesField.getText());
			if (qtydelements>0 && qtynodes>0)
			{
				JLabel stagetwotext2 = new JLabel("Enter all "+qtydelements+" data elements to fill the table,");
				stagetwotext2.setAlignmentX(Component.CENTER_ALIGNMENT);
				typicaldataTable=new ExcellTable(qtydelements+1, qtynodes+1, 440, 385);
				typicaldataTable.tableSetTitle("The typical data T");
				for (int i=0;i<qtydelements;i++)
				{
					typicaldataTable.tableSetStringAt("data "+(i+1), i+2, 1);
				}
				for (int i=0;i<qtynodes;i++)
				{
					typicaldataTable.tableSetStringAt("node "+(i+1), 1, i+2);
				}
				mainPanel.add(new Box.Filler(spacebox1, spacebox1, spacebox1));
				mainPanel.add(new centerJLabel("Stage 2"));
				mainPanel.add(stagetwotext2);
				mainPanel.add(new centerJLabel("you can past from an Excel spreadsheet or text editor using Ctrl + v."));
				mainPanel.add(typicaldataTable);
				mainPanel.add(Box.createVerticalGlue());
				this.getContentPane().validate();
				this.getContentPane().repaint();
				mainverticalBar.setValue(mainverticalBar.getMaximum());
				qtydelementsField.setEnabled(false);
				qtynodesField.setEnabled(false);
				allowable=true;
			}
			else
			{
				Toolkit.getDefaultToolkit().beep();
				allowable=false;
			}
		}
		catch (NumberFormatException x)
		{
			Toolkit.getDefaultToolkit().beep();
			allowable=false;
		}
	}
	private void stageThree()
	{
		typicaldataTable.trimSpaces();
		if (typicaldataTable.noEmptyCells()==true)
		{
			qtynoderepertoire=typicaldataTable.repertoireSize();
			System.out.println("Size of node repertoire "+qtynoderepertoire);
			JLabel stagethreetext2 = new JLabel("The nodes have a "+qtynoderepertoire+" state repertoire.");
			stagethreetext2.setAlignmentX(Component.CENTER_ALIGNMENT);
			uoptionsTable=new ExcellTable(qtynoderepertoire+1, qtynoderepertoire+1, 440, 385);
			uoptionsTable.tableSetTitle("Options for U");
			for (int i=0;i<qtynoderepertoire;i++)
			{
				uoptionsTable.tableSetStringAt("1", i+2, i+2);
			}
			mainPanel.add(new Box.Filler(spacebox1, spacebox1, spacebox1));
			mainPanel.add(new centerJLabel("Stage 3"));
			mainPanel.add(stagethreetext2);
			mainPanel.add(new centerJLabel("See Help for how to complete the following table for these states."));
			mainPanel.add(uoptionsTable);
			mainPanel.add(Box.createVerticalGlue());
			this.getContentPane().validate();
			this.getContentPane().repaint();
			mainverticalBar.setValue(mainverticalBar.getMaximum());
			allowable=true;
		}
		else
		{
			Toolkit.getDefaultToolkit().beep();
			allowable=false;
		}
	}
	private void stageFour()
	{
		uoptionsTable.trimSpaces();
		if (uoptionsTable.relation()==true)
		{
			roptionsTable=new ExcellTable(qtynodes+1, qtynodes+1, 440, 385);
			roptionsTable.tableSetTitle("Options for R");
			for (int i=0;i<qtynodes;i++)
			{
				roptionsTable.tableSetStringAt("1", i+2, i+2);
				roptionsTable.tableSetStringAt("node "+(i+1), 1, i+2);
				roptionsTable.tableSetStringAt("node "+(i+1), i+2, 1);
			}
			modeText1 = new TextPlate("Calculate and display the weighted relation R(U_op1,S_i) on the set of nodes, S, :given by the first option in the table of options given for U and the data :element S_i of T. Note that for nodes a, b in S we have :R(U_op1,S_i)(a,b) = U_op1(f_i(a),f_i(b)) where f_i is the function defined by data i.: ");
			modeText2 = new TextPlate("Calculate and display the weighted relation R_T on the set of nodes, S, where for :a, b in S, R_T(a,b)  is the mean of the values R(U_op1,S_i)(a,b) given by all :the S_i of T.: ");
			modeText3 = new TextPlate("Calculate and display the float entropy fe(R_op1,U_op1,S_i) of S_i with respect :to the first option given for R, the first option given for U and the metric :d_n used. See Help for more details.: ");
			modeText4 = new TextPlate("Calculate and display the expected float entropy efe(R_op1,U_op1,T), which here is :the mean of the individual float entropies, with respect to the first option :given for R, the first option given for U and the metric d_n used. See Help for :more details.: ");
			modeText5 = new TextPlate("Calculate and display the distance d_n(R_op1,R(U_op1,S_i)) with respect to the :first option given for R, the first option given for U and the metric d_n used. :See Help for more details.: ");
			modeText6 = new TextPlate("Calculate and display the expected distance d_n(R_op1,U_op1,T), which here is the :mean of the individual distances, with respect to the first option given for R, :the first option given for U and the metric d_n used. See Help for more details.: ");
			modeText7 = new TextPlate("From the selected options, find and display the best approximations of U and R. :Hence the options displayed will be those that minimise the expected float :entropy. Whilst uniqueness is not always guaranteed, for given T our aim is to :find U and R for which efe(R,U,T) is minimised.: ");
			modeText8 = new TextPlate("Calculate and display observations of expected float entropy as a random variable. :The random variable is given by efe(R_random,U_random,T), where the entries in :R_random and U_random are chosen at random (uniformly) from a number of :equally spaced values between 0 and 1. The number of values can be set to infinity.: ");
			modeText9 = new TextPlate("Calculate and display the float entropy fe(R_op1,U_op1,S_i) of each S_i of T with :respect to the first option given for R, the first option given for U and the metric :d_n used. See Help for more details.: ");
			JPanel stagefourPanel1 = new JPanel();
			stagefourPanel1.setBackground(Color.white);
			stagefourPanel1.setLayout(new BoxLayout(stagefourPanel1, BoxLayout.Y_AXIS));
			stagefourPanel1.setAlignmentX(Component.CENTER_ALIGNMENT);
			stagefourPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Processing modes", TitledBorder.CENTER, TitledBorder.TOP));
			stagefourPanel1.add(modeText1);
			stagefourPanel1.add(modeText2);
			stagefourPanel1.add(modeText3);
			stagefourPanel1.add(modeText4);
			stagefourPanel1.add(modeText5);
			stagefourPanel1.add(modeText6);
			stagefourPanel1.add(modeText7);
			stagefourPanel1.add(modeText8);
			stagefourPanel1.add(modeText9);
			dnmetricField.setText("1");
			JPanel stagefourPanel2 = new JPanel();
			stagefourPanel2.setBackground(Color.white);
			stagefourPanel2.setMaximumSize(new Dimension(2000, 400));
			stagefourPanel2.add(new JLabel("From T use data element "));
			stagefourPanel2.add(delementField);
			stagefourPanel2.add(new JLabel("Use metric d_n with n equal to "));
			stagefourPanel2.add(dnmetricField);
			JPanel stagefourPanel2part2 = new JPanel();
			stagefourPanel2part2.setBackground(Color.white);
			stagefourPanel2part2.setMaximumSize(new Dimension(2000, 400));
			stagefourPanel2part2.add(new JLabel("Number of observations "));
			stagefourPanel2part2.add(observationsField);
			stagefourPanel2part2.add(new JLabel("Number of values "));
			stagefourPanel2part2.add(entriesresField);
			allucombinations = new JRadioButton("Try every combination of the options given for U");
			allucombinations.setBackground(Color.white);
			allucombinations.setSelected(true);
			allucombinations.setAlignmentX(Component.LEFT_ALIGNMENT);
			urespectively = new JRadioButton("Treating the options as an ordered list, try each option given for U");
			urespectively.setBackground(Color.white);
			urespectively.setAlignmentX(Component.LEFT_ALIGNMENT);
			uperturbations = new JRadioButton("Try perturbations using the options given for U");
			uperturbations.setBackground(Color.white);
			uperturbations.setAlignmentX(Component.LEFT_ALIGNMENT);
			allrcombinations = new JRadioButton("Try every combination of the options given for R");
			allrcombinations.setBackground(Color.white);
			allrcombinations.setSelected(true);
			allrcombinations.setAlignmentX(Component.LEFT_ALIGNMENT);
			rrespectively = new JRadioButton("Treating the options as an ordered list, try each option given for R");
			rrespectively.setBackground(Color.white);
			rrespectively.setAlignmentX(Component.LEFT_ALIGNMENT);
			rperturbations = new JRadioButton("Try perturbations using the options given for R");
			rperturbations.setBackground(Color.white);
			rperturbations.setAlignmentX(Component.LEFT_ALIGNMENT);
			ButtonGroup groupu = new ButtonGroup();
			ButtonGroup groupr = new ButtonGroup();
			groupu.add(allucombinations);
			groupu.add(urespectively);
			groupu.add(uperturbations);
			groupr.add(allrcombinations);
			groupr.add(rrespectively);
			groupr.add(rperturbations);
			JPanel stagefourPanel3 = new JPanel();
			stagefourPanel3.setBackground(Color.white);
			stagefourPanel3.setLayout(new BoxLayout(stagefourPanel3, BoxLayout.Y_AXIS));
			stagefourPanel3.setMaximumSize(new Dimension(475, 400));
			stagefourPanel3.setAlignmentX(Component.CENTER_ALIGNMENT);
			stagefourPanel3.add(allucombinations);
			stagefourPanel3.add(urespectively);
			stagefourPanel3.add(uperturbations);
			stagefourPanel3.add(allrcombinations);
			stagefourPanel3.add(rrespectively);
			stagefourPanel3.add(rperturbations);
			mainPanel.add(new Box.Filler(spacebox1, spacebox1, spacebox1));
			mainPanel.add(new centerJLabel("Stage 4"));
			mainPanel.add(new centerJLabel("Select the processing mode using Select."));
			mainPanel.add(new centerJLabel("Check that all fields are complete where indicated and then Progress."));
			mainPanel.add(roptionsTable);
			mainPanel.add(new Box.Filler(spacebox3, spacebox3, spacebox3));
			mainPanel.add(stagefourPanel1);
			mainPanel.add(new Box.Filler(spacebox3, spacebox3, spacebox3));
			mainPanel.add(stagefourPanel2);
			mainPanel.add(new Box.Filler(spacebox3, spacebox3, spacebox3));
			mainPanel.add(stagefourPanel2part2);
			mainPanel.add(new Box.Filler(spacebox3, spacebox3, spacebox3));
			mainPanel.add(stagefourPanel3);
			mainPanel.add(new Box.Filler(spacebox3, spacebox3, spacebox3));
			mainPanel.add(new centerJLabel("------- Outputs -------"));
			mainPanel.add(Box.createVerticalGlue());
			this.getContentPane().validate();
			this.getContentPane().repaint();
			mainverticalBar.setValue(mainverticalBar.getMaximum());
			modeProcessor1=new ModeProcessor(typicaldataTable,uoptionsTable,roptionsTable,mainPanel,mainverticalBar);
			select.setEnabled(true);
			allowable=true;
		}
		else
		{
			Toolkit.getDefaultToolkit().beep();
			allowable=false;
		}
	}
	private void stageFive()
	{
		inputsEnabled(false);
		typicaldataTable.trimSpaces();
		uoptionsTable.trimSpaces();
		roptionsTable.trimSpaces();
		if ((mode!=0) && ((typicaldataTable.noEmptyCells()) && (uoptionsTable.relation())))
		{
			if (modeProcessor1.composable()==true)
			{
				modeProcessor1.proceed=true;
				prothread = new ProcessingThread();
				prothread.setPriority(5);
				prothread.start();
			}
			else
			{
				Toolkit.getDefaultToolkit().beep();
				inputsEnabled(true);
			}
		}
		else
		{
			Toolkit.getDefaultToolkit().beep();
			inputsEnabled(true);
		}
	}
	private void inputsEnabled(boolean theboolean)
	{
		stop.setEnabled(!theboolean);
		select.setEnabled(theboolean);
		progress.setEnabled(theboolean);
		typicaldataTable.tabelEnabled(theboolean);
		uoptionsTable.tabelEnabled(theboolean);
		roptionsTable.tabelEnabled(theboolean);
		delementField.setEnabled(theboolean);
		dnmetricField.setEnabled(theboolean);
		observationsField.setEnabled(theboolean);
		entriesresField.setEnabled(theboolean);
		allucombinations.setEnabled(theboolean);
		urespectively.setEnabled(theboolean);
		uperturbations.setEnabled(theboolean);
		allrcombinations.setEnabled(theboolean);
		rrespectively.setEnabled(theboolean);
		rperturbations.setEnabled(theboolean);
	}
	class ProcessingThread extends Thread
	{
		int iofSi;
		int nofdn;
		int numobservs;
		int numentriesres;
		boolean inputok;
		public void run()
		{
			inputok=false;
			if ((mode==1) && usedelementok())
			{
				modeProcessor1.modeOne(iofSi);
				inputok=true;
			}
			if (mode==2)
			{
				modeProcessor1.modeTwo();
				inputok=true;
			}
			if ((mode==3) && (usedelementok() && (dnmetricok() && roptionsTable.relation())))
			{
				modeProcessor1.modeThree(iofSi, nofdn);
				inputok=true;
			}
			if ((mode==4) && (dnmetricok() && roptionsTable.relation()))
			{
				modeProcessor1.modeFour(nofdn);
				inputok=true;
			}
			if ((mode==5) && (usedelementok() && (dnmetricok() && roptionsTable.relation())))
			{
				modeProcessor1.modeFive(iofSi, nofdn);
				inputok=true;
			}
			if ((mode==6) && (dnmetricok() && roptionsTable.relation()))
			{
				modeProcessor1.modeSix(nofdn);
				inputok=true;
			}
			if ((mode==7) && (dnmetricok() && roptionsTable.relation()))
			{
				modeProcessor1.modeSeven(nofdn,radioToIntR(),radioToIntU());
				inputok=true;
			}
			if ((mode==8) && (dnmetricok() && (useobservationsok() && useentriesresok())))
			{
				modeProcessor1.modeEight(nofdn, numobservs, numentriesres);
				inputok=true;
			}
			if ((mode==9) && (dnmetricok() && roptionsTable.relation()))
			{
				modeProcessor1.modeNine(nofdn);
				inputok=true;
			}
			if (!inputok)
			{
				Toolkit.getDefaultToolkit().beep();
			}
			try
			{
				sleep(1000);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
			inputsEnabled(true);
		}
		private boolean usedelementok()
		{
			try 
			{
				iofSi=Integer.parseInt(delementField.getText());
				if (iofSi>0 && iofSi<qtydelements+1)
				{
					return true;
				}
				else
				{
					return false;
				}
			}
			catch (NumberFormatException x)
			{
				return false;
			}
		}
		private boolean dnmetricok()
		{
			try 
			{
				nofdn=Integer.parseInt(dnmetricField.getText());
				if ((nofdn>0) && (nofdn<5))
				{
					return true;
				}
				else
				{
					return false;
				}
			}
			catch (NumberFormatException x)
			{
				if ((dnmetricField.getText().equals("infinity")) || (dnmetricField.getText().equals("Infinity")))
				{
					nofdn=100;
					return true;
				}
				else
				{
				return false;
				}
			}
		}
		private boolean useobservationsok()
		{
			try 
			{
				numobservs=Integer.parseInt(observationsField.getText());
				if (numobservs>0)
				{
					return true;
				}
				else
				{
					return false;
				}
			}
			catch (NumberFormatException x)
			{
				return false;
			}
		}
		private boolean useentriesresok()
		{
			try 
			{
				numentriesres=Integer.parseInt(entriesresField.getText());
				if (numentriesres>0)
				{
					return true;
				}
				else
				{
					return false;
				}
			}
			catch (NumberFormatException x)
			{
				if ((entriesresField.getText().equals("infinity")) || (entriesresField.getText().equals("Infinity")))
				{
					numentriesres=-1;
					return true;
				}
				else
				{
				return false;
				}
			}
		}
		private int radioToIntR()
		{
			int radint=1;
			if (rrespectively.isSelected())
			{
				radint=2;
			}
			else
			{
				if (rperturbations.isSelected())
				{
					radint=3;
				}
			}
			return radint;
		}
		private int radioToIntU()
		{
			int radint=1;
			if (urespectively.isSelected())
			{
				radint=2;
			}
			else
			{
				if (uperturbations.isSelected())
				{
					radint=3;
				}
			}
			return radint;
		}
	}
}

class centerJLabel extends JLabel
{
	private static final long serialVersionUID = 1324534132542L;
	public centerJLabel(String thetext)
	{
		this.setText(thetext);
		this.setAlignmentX(Component.CENTER_ALIGNMENT);
	}
}

class TextPlate extends JPanel
{
	private static final long serialVersionUID = 9687126359017L;
	public TextPlate(String thetext)
	{
		this.setBackground(Color.white);
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		this.setAlignmentX(Component.LEFT_ALIGNMENT);
		for (int i=0;i<(thetext.split(":")).length;i++)
		{
			this.add(new leftJLabel((String) (thetext.split(":"))[i]));
		}
	}
	class leftJLabel extends JLabel
	{
		private static final long serialVersionUID = 7192875478935L;
		public leftJLabel(String linetext)
		{
			this.setText(linetext);
			this.setAlignmentX(Component.LEFT_ALIGNMENT);
		}
	}
}

class ExcellTable extends JPanel
{
int numrows;
int numcols;
int auxint;
double auxdouble;
boolean noempties;
boolean auxboolean;
String auxstring = new String();
JTable jTable1 ;
private static final long serialVersionUID = 8756319557409L;
public ExcellTable(int trows, int tcols, int portwidth, int portheight)
{
   super();
   try
   {
	  numrows=trows;
	  numcols=tcols; 
      jbInit(portwidth, portheight);
   }
   catch (Exception e)
   {
      e.printStackTrace();
   }
}
private void jbInit(int viewportwidth, int viewportheight) throws Exception
{
Object[][] data=new Object[numrows][numcols];
Object[] header=new Object[numcols];
for (int i=0;i<numcols;i++)
{
	header[i]=new Integer(i);
}
jTable1=new JTable(data,header);
jTable1.setCellSelectionEnabled(true);
jTable1.setBackground(Color.white);
jTable1.setPreferredScrollableViewportSize(new Dimension(viewportwidth, viewportheight));
JScrollPane scrollPane = new JScrollPane(jTable1, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
for (int i=0;i<numcols;i++)
{
	jTable1.getColumnModel().getColumn(i).setMaxWidth(55);
}
jTable1.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
scrollPane.getViewport().setBackground(Color.white);
this.add(scrollPane, BorderLayout.CENTER);
this.setMaximumSize(new Dimension(viewportwidth+40, viewportheight+90));
this.setBackground(Color.white);
// This is the line that does all the magic!
@SuppressWarnings("unused")
ExcelAdapter myAd = new ExcelAdapter(jTable1);
}
public void trimSpaces()
{
	for (int i=0;i<numrows;i++)
	{
		for (int j=0;j<numcols;j++)
		{
			auxstring=(String) jTable1.getValueAt(i,j);
			if (auxstring!=null)
			{
				jTable1.setValueAt(auxstring.trim(), i, j);
			}
		}
	}
}
public void tableSelected(boolean selected)
{
	if (selected==true)
	{
		this.setBackground(new Color(200,225,255));
	}
	else
	{
		this.setBackground(Color.white);
	}
}
public void tabelEnabled(boolean theboolean)
{
	jTable1.setEnabled(theboolean);
}
public void tableSetTitle(String settitle)
{
	this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), settitle, TitledBorder.CENTER, TitledBorder.TOP));
}
public String tableValAt(int valrow, int valcol)
{
	return (String) jTable1.getValueAt(valrow-1, valcol-1);
}
public void tableSetStringAt(String setcellvalue, int setrow, int setcol)
{
	jTable1.setValueAt(setcellvalue ,setrow-1, setcol-1);
}
public void tableSetIntAt(int setcellvalue, int setrow, int setcol)
{
	jTable1.setValueAt(setcellvalue ,setrow-1, setcol-1);
}
public boolean noEmptyCells()
{
	noempties=true;
	for (int i=0;i<numrows-1;i++)
	{
		for (int j=0;j<numcols-1;j++)
		{
			auxstring=(String) jTable1.getValueAt(i+1,j+1);
			if (auxstring==null)
			{
				noempties=false;
			}
			else
			{
				if (auxstring.trim().length()==0)
				{
					noempties=false;
				}
			}
		}
	}
	return noempties;
}
public boolean noEmptyHeaders()
{
	auxboolean=true;
	for (int i=0;i<numrows-1;i++)
	{
		auxstring=(String) jTable1.getValueAt(i+1,0);
		if (auxstring==null)
		{
			auxboolean=false;
		}
		else
		{
			if (auxstring.trim().length()==0)
			{
				auxboolean=false;
			}
		}
	}
	for (int i=0;i<numcols-1;i++)
	{
		auxstring=(String) jTable1.getValueAt(0,i+1);
		if (auxstring==null)
		{
			auxboolean=false;
		}
		else
		{
			if (auxstring.trim().length()==0)
			{
				auxboolean=false;
			}
		}
	}
	return auxboolean;
}
public int repertoireSize()
{
	auxint=0;
	for (int i=0;i<numrows-1;i++)
	{
		for (int j=0;j<numcols-1;j++)
		{
			auxboolean=true;
			if (i>0)
			{
				for (int k=0;k<i;k++)
				{
					for (int l=0;l<numcols-1;l++)
					{
						if (((String) jTable1.getValueAt(k+1,l+1)).equals((String) jTable1.getValueAt(i+1,j+1)))
						{
							auxboolean=false;
						}
					}
				}
			}
			if (j>0)
			{
				for (int l=0;l<j;l++)
				{
					if (((String) jTable1.getValueAt(i+1,l+1)).equals((String) jTable1.getValueAt(i+1,j+1)))
					{
						auxboolean=false;
					}	
				}
			}
			if (auxboolean==true)
			{
				auxint++;
			}
		}
	}
	return auxint;
}
public boolean reflexive()
{
	auxboolean=true;
	if (numrows!=numcols)
	{
		auxboolean=false;
	}
	else
	{
		for (int i=0;i<numrows-1;i++)
		{
			if ((((String) jTable1.getValueAt(i+1,i+1)).equals("1")) || (((String) jTable1.getValueAt(i+1,i+1)).equals("1.0")))
			{
			}
			else
			{
				auxboolean=false;
			}
		}
	}
	return auxboolean;
}
public boolean symmetric()
{
	auxboolean=true;
	if (numrows!=numcols)
	{
		auxboolean=false;
	}
	else
	{
		for (int i=0;i<numrows-1;i++)
		{
			for (int j=i+1;j<numcols;j++)
			{
				if ((((String) jTable1.getValueAt(i,j))==null) || (((String) jTable1.getValueAt(j,i))==null))
				{
					auxboolean=false;
				}
				else
				{
					if (((String) jTable1.getValueAt(i,j)).equals((String) jTable1.getValueAt(j,i)))
					{
					}
					else
					{
						auxboolean=false;
					}
				}
			}
		}
	}
	return auxboolean;
}
public boolean weighted()
{
	auxboolean=true;
	for (int i=0;i<numrows-1;i++)
	{
		for (int j=0;j<numcols-1;j++)
		{
			auxstring=(String) jTable1.getValueAt(i+1,j+1);
			if (auxstring==null)
			{
				auxboolean=false;
			}
			else
			{
				System.out.println("number of values "+(auxstring.split(":")).length);
				if ((auxstring.split(":")).length==0)
				{
					auxboolean=false;
				}
				else
				{
					for (int k=0;k<(auxstring.split(":")).length;k++)
					{
						try 
						{
							auxdouble=Double.parseDouble((auxstring.split(":"))[k]);
							System.out.println("value "+auxdouble);
							if (auxdouble<0 || auxdouble>1)
							{
								auxboolean=false;
							}
							else
							{
								/*if ((i!=j) && (auxdouble==1))
								{
									auxboolean=false;
								}*/
							}
						}
						catch (NumberFormatException x)
						{
							auxboolean=false;
						}
					}
				}
			}
		}
	}
	return auxboolean;
}
public boolean relation()
{
	auxboolean=true;
	if ((noEmptyCells()==true) && (noEmptyHeaders()==true))
	{
		if (((reflexive()==true) && (symmetric()==true)) && (weighted()==true))
		{
		}
		else
		{
			auxboolean=false;
		}
	}
	else
	{
		auxboolean=false;
	}
	return auxboolean;
}
}

class ModeProcessor
{
	int nodeaxis;
	int dataaxis;
	int repertoireaxis;
	boolean proceed;
	int auxint;
	int auxintk;
	boolean auxboolean;
	String auxstring;
	Dimension spacebox4 = new Dimension(40, 40);
	ExcellTable typicalData;
	ExcellTable uOptions;
	ExcellTable rOptions;
	int[][] selectFirstU;
	int[][] selectFirstR;
	int[][] uTest;
	int[][] rTest;
	int[][] dataArray;
	double[][][] uOptionsArray;
	double[][][] rOptionsArray;
	String[][] uStore;
	String[][] rStore;
	JPanel outputPanel;
	JScrollBar outputPanelBar;
	Random auxrandom = new Random();
	public ModeProcessor(ExcellTable theData, ExcellTable theUOptions, ExcellTable theROptions, JPanel thePanel, JScrollBar theScrollBar)
	{
		typicalData=theData;
		uOptions=theUOptions;
		rOptions=theROptions;
		outputPanel=thePanel;
		outputPanelBar=theScrollBar;
		nodeaxis=theData.numcols;
		dataaxis=theData.numrows;
		repertoireaxis=theUOptions.numcols;
		selectFirstU = new int[repertoireaxis][repertoireaxis];
		selectFirstR = new int[nodeaxis][nodeaxis];
		for (int i=0;i<repertoireaxis-1;i++)
		{
			for (int j=0;j<repertoireaxis-1;j++)
			{
				selectFirstU[i+1][j+1]=0;
			}
		}
		for (int i=0;i<nodeaxis-1;i++)
		{
			for (int j=0;j<nodeaxis-1;j++)
			{
				selectFirstR[i+1][j+1]=0;
			}
		}
	}
	public boolean composable()
	{
		auxboolean=true;
		searcha: for (int i=0;i<dataaxis-1;i++)
		{
			for (int j=0;j<nodeaxis-1;j++)
			{
				auxint=0;
				for (int k=0;k<repertoireaxis-1;k++)
				{
					if ((typicalData.tableValAt(i+2, j+2)).equals(uOptions.tableValAt(1, k+2)))
					{
						auxint++;
					}
				}
				if (auxint!=1)
				{
					auxboolean=false;
					break searcha;
				}
			}
		}
		return auxboolean;
	}
	private void setDataArray()
	{
		dataArray = new int[dataaxis][nodeaxis];
		for (int i=0;i<dataaxis-1;i++)
		{
			for (int j=0;j<nodeaxis-1;j++)
			{
				for (int k=0;k<repertoireaxis-1;k++)
				{
					if ((typicalData.tableValAt(i+2, j+2)).equals(uOptions.tableValAt(1, k+2)))
					{
						dataArray[i+1][j+1]=k+1;
						break;
					}
				}
			}
		}
	}
	private void setuOptionsArray()
	{
		uOptionsArray = new double[repertoireaxis][repertoireaxis][];
		for (int i=0;i<repertoireaxis-1;i++)
		{
			for (int j=0;j<repertoireaxis-1;j++)
			{
				auxstring=uOptions.tableValAt(i+2, j+2);
				uOptionsArray[i+1][j+1] = new double[(auxstring.split(":")).length];
				for (int k=0;k<(auxstring.split(":")).length;k++)
				{
					uOptionsArray[i+1][j+1][k]=Double.parseDouble((auxstring.split(":"))[k]);
				}
			}
		}
	}
	private void setrOptionsArray()
	{
		rOptionsArray = new double[nodeaxis][nodeaxis][];
		for (int i=0;i<nodeaxis-1;i++)
		{
			for (int j=0;j<nodeaxis-1;j++)
			{
				auxstring=rOptions.tableValAt(i+2, j+2);
				rOptionsArray[i+1][j+1] = new double[(auxstring.split(":")).length];
				for (int k=0;k<(auxstring.split(":")).length;k++)
				{
					rOptionsArray[i+1][j+1][k]=Double.parseDouble((auxstring.split(":"))[k]);
				}
			}
		}
	}
	private void setranduOptionsArray(int theentriesval)
	{
		double tempranddouble;
		uOptionsArray = new double[repertoireaxis][repertoireaxis][1];
		for (int i=0;i<repertoireaxis-1;i++)
		{
			uOptionsArray[i+1][i+1][0]=1;
		}
		for (int i=0;i<repertoireaxis-2;i++)
		{
			for (int j=i;j<repertoireaxis-2;j++)
			{
				tempranddouble=randomGenerater(theentriesval);
				uOptionsArray[i+1][j+2][0]=tempranddouble;
				uOptionsArray[j+2][i+1][0]=tempranddouble;
			}
		}
	}
	private void setrandrOptionsArray(int theentriesval)
	{
		double tempranddouble;
		rOptionsArray = new double[nodeaxis][nodeaxis][1];
		for (int i=0;i<nodeaxis-1;i++)
		{
			rOptionsArray[i+1][i+1][0]=1;
		}
		for (int i=0;i<nodeaxis-2;i++)
		{
			for (int j=i;j<nodeaxis-2;j++)
			{
				tempranddouble=randomGenerater(theentriesval);
				rOptionsArray[i+1][j+2][0]=tempranddouble;
				rOptionsArray[j+2][i+1][0]=tempranddouble;
			}
		}
	}
	private double randomGenerater(int numberofintervals)
	{
		double randomdouble=0;
		double intervalwidth=0;
		double randomval=auxrandom.nextDouble();
		if (numberofintervals==-1)
		{
			return randomval;
		}
		else
		{
			intervalwidth=1/((double) numberofintervals);
			valuefinder: for (int i=1;i<numberofintervals+1;i++)
			{
				randomdouble=((double) i-0.5)*intervalwidth;
				if (randomval<=i*intervalwidth)
				{
					break valuefinder;
				}
			}
			return randomdouble;
		}
	}
	private double[][] RUSi(int dataindex, int[][] whichUoption)
	{
		double[][] RUSidouble = new double[nodeaxis][nodeaxis];
		for (int i=0;i<nodeaxis-1;i++)
		{
			for (int j=0;j<nodeaxis-1;j++)
			{
				RUSidouble[i+1][j+1]=uOptionsArray[dataArray[dataindex][i+1]][dataArray[dataindex][j+1]][whichUoption[dataArray[dataindex][i+1]][dataArray[dataindex][j+1]]];
			}
		}
		return RUSidouble;
	}
	private double[][] RT(int[][] theUoption)
	{
		double[][] RTdouble = new double[nodeaxis][nodeaxis];
		RTdouble=RUSi(1, theUoption);
		if (dataaxis>2)
		{
			double[][] tempdouble = new double[nodeaxis][nodeaxis];
			for (int k=2;k<dataaxis;k++)
			{
				tempdouble=RUSi(k, theUoption);
				for (int i=0;i<nodeaxis-1;i++)
				{
					for (int j=0;j<nodeaxis-1;j++)
					{
						RTdouble[i+1][j+1]=RTdouble[i+1][j+1]+tempdouble[i+1][j+1];
					}
				}
			}
			for (int i=0;i<nodeaxis-1;i++)
			{
				for (int j=0;j<nodeaxis-1;j++)
				{
					RTdouble[i+1][j+1]=RTdouble[i+1][j+1]/((double) (dataaxis-1));
				}
			}
		}
		return RTdouble;
	}
	private double dnMetric(int valueofn, int[][] whichRoption, double[][] theRUSi, boolean takenthroot)
	{
		double tempdouble=0;
		if ((valueofn>0) && (valueofn<5))
		{
			for (int i=0;i<nodeaxis-1;i++)
			{
				for (int j=0;j<nodeaxis-1;j++)
				{
					tempdouble=tempdouble+Math.pow(Math.abs(rOptionsArray[i+1][j+1][whichRoption[i+1][j+1]]-theRUSi[i+1][j+1]), ((double) valueofn));
				}
			}
			if (takenthroot && (valueofn!=1))
			{
				if (valueofn==2)
				{
					tempdouble=Math.sqrt(tempdouble);
				}
				else
				{
					if (valueofn==3)
					{
						tempdouble=Math.cbrt(tempdouble);
					}
					else
					{
						tempdouble=Math.sqrt(Math.sqrt(tempdouble));
					}
				}
			}
		}
		else
		{
			if (valueofn==100)
			{
				for (int i=0;i<nodeaxis-1;i++)
				{
					for (int j=0;j<nodeaxis-1;j++)
					{
						tempdouble=Math.max(tempdouble, Math.abs(rOptionsArray[i+1][j+1][whichRoption[i+1][j+1]]-theRUSi[i+1][j+1]));
					}
				}
			}
		}
		return tempdouble;
	}
	private double dnRUT(int valueofn, int[][] theRoption, int[][] theUoption)
	{
		double tempdouble=0;
		for (int i=0;i<dataaxis-1;i++)
		{
			tempdouble=tempdouble+dnMetric(valueofn, theRoption, RUSi(i+1, theUoption), true);
		}
		tempdouble=tempdouble/((double) (dataaxis-1));
		return tempdouble;
	}
	private boolean generateSj(int place)
	{
		if (place>nodeaxis-1)
		{
			return false;
		}
		else
		{
			if (dataArray[0][place]+1<repertoireaxis)
			{
				dataArray[0][place]=dataArray[0][place]+1;
				return true;
			}
			else
			{
				dataArray[0][place]=1;
				return generateSj(place+1);
			}
			
		}
	}
	private double feRUSi(int valueofn, int[][] theRoption, int[][] theUoption, int dataindex)
	{
		double tempdouble=0;
		double dnRRUSi=dnMetric(valueofn, theRoption, RUSi(dataindex, theUoption), false);
		for (int i=0;i<nodeaxis-1;i++)
		{
			dataArray[0][i+1]=1;
		}
		do
		{
			if (dnMetric(valueofn, theRoption, RUSi(0, theUoption), false)<=dnRRUSi)
			{
				tempdouble++;
			}
		} while (generateSj(1));
		tempdouble=Math.log((double) tempdouble)/Math.log(2.0);
		return tempdouble;
	}
	private double feRUT(int valueofn, int[][] theRoption, int[][] theUoption, boolean fast, double breakvalue)
	{
		int numstates = (int) Math.pow(repertoireaxis-1,nodeaxis-1);
		int[][] sortlist = new int[numstates][2];
		for (int i=0;i<numstates;i++)
		{
			sortlist[i][0]=i;
		}
		auxintk=1;
		quickSort(sortlist, 0, numstates-1, valueofn, theRoption, theUoption);
		int countint=0;
		int swapa;
		int swapb;
		int remsort=sortlist[0][1];
		sortlist[0][1]=numstates;
		for (int i=1;i<numstates;i++)
		{
			if (sortlist[i][1]!=remsort)
			{
				countint=i;
				remsort=sortlist[i][1];
			}
			sortlist[i][1]=numstates-countint;
		}
		countint=0;
		while (countint<numstates-1)
		{
			if (sortlist[countint][0]!=countint)
			{
				swapa=sortlist[sortlist[countint][0]][0];
				swapb=sortlist[sortlist[countint][0]][1];
				sortlist[sortlist[countint][0]][0]=sortlist[countint][0];
				sortlist[sortlist[countint][0]][1]=sortlist[countint][1];
				sortlist[countint][0]=swapa;
				sortlist[countint][1]=swapb;
			}
			else
			{
				countint++;
			}
		}
		double tempdouble=0;
		BigDecimal tempBigDec=new BigDecimal("0");
		if (fast)
		{
			int tempint=0;
			while ((tempint<dataaxis-1) && (tempdouble<=breakvalue))
			{
				tempBigDec=tempBigDec.add(BigDecimal.valueOf(Math.log((double) sortlist[tindextoindex(tempint+1)][1])/Math.log(2.0)));
				tempdouble=tempBigDec.doubleValue();
				tempint++;
			}
		}
		else
		{
			for (int i=0;i<dataaxis-1;i++)
			{
				tempBigDec=tempBigDec.add(BigDecimal.valueOf(Math.log((double) sortlist[tindextoindex(i+1)][1])/Math.log(2.0)));
			}
			tempdouble=tempBigDec.doubleValue();
			tempdouble=tempdouble/((double) (dataaxis-1));
		}
		return tempdouble;
	}
	private void indextostate(int indexint)
	{
		double tempdouble = indexint;
		int tempint;
		for (int i=nodeaxis-1;i>0;i--)
		{
			tempint = (int) (tempdouble/Math.pow(repertoireaxis-1,i-1));
			dataArray[0][i]= tempint+1;
			tempdouble = tempdouble-tempint*Math.pow(repertoireaxis-1,i-1);
		}
	}
	private int tindextoindex(int tindexint)
	{
		int tempint = 0;
		for (int i=nodeaxis-1;i>0;i--)
		{
			tempint = tempint+(dataArray[tindexint][i]-1)*((int) Math.pow(repertoireaxis-1,i-1));
		}
		return tempint;
	}
	private void quickSort(int arr[][], int begin, int end, int valueofn, int[][] theRoption, int[][] theUoption) 
	{
	    if (begin < end) 
	    {
	        int[] partitionIndex = partition(arr, begin, end, valueofn, theRoption, theUoption);
	        /*System.out.println("partitionIndex0=" +partitionIndex[0] +"partitionIndex1=" +partitionIndex[1]);*/
	        auxintk++;
	        quickSort(arr, begin, partitionIndex[0], valueofn, theRoption, theUoption);
	        auxintk++;
	        quickSort(arr, partitionIndex[1], end, valueofn, theRoption, theUoption);
	    }
	}
	private int[] partition(int arr[][], int begin, int end, int valueofn, int[][] theRoption, int[][] theUoption) 
	{
		indextostate(arr[(int) (end+begin)/2][0]);
		double pivot = dnMetric(valueofn, theRoption, RUSi(0, theUoption), false);
	    int i = (begin-1);
	    int k = (end+1);
	    int swapTempone;
	    int swapTemptwo;
	    double dnmetatj;
	    for (int j = begin; j < end+1; j++) 
	    {
	    	indextostate(arr[j][0]);
	    	dnmetatj = dnMetric(valueofn, theRoption, RUSi(0, theUoption), false);
	        if ((dnmetatj > pivot) || (0 < arr[j][1])) 
	        {
	            i++;
	 
	            swapTempone = arr[i][0];
	            swapTemptwo = arr[i][1];
	            arr[i][0] = arr[j][0];
	            arr[i][1] = arr[j][1];
	            arr[j][0] = swapTempone;
	            arr[j][1] = swapTemptwo;
	        }
	        else
	        {
	        	if (dnmetatj == pivot)
	        	{
	        		k--;
	        		
		            swapTempone = arr[k][0];
		            arr[k][0] = arr[j][0];
		            arr[j][0] = swapTempone;
		            arr[j][1] = arr[k][1];
		            arr[k][1] = auxintk;
		            j--;
	        	}
	        }
	    }
	    int[] parindex = new int[2];
	    parindex[0]=i-(end+1-k);
	    parindex[1]=i+1;
	    return parindex;
	}
	private double approximateUR(int valueofn, int radiobuttonr, int radiobuttonu)
	{
		rStore = new String[nodeaxis][nodeaxis];
		uStore = new String[repertoireaxis][repertoireaxis];
		rTest = new int[nodeaxis][nodeaxis];
		uTest = new int[repertoireaxis][repertoireaxis];
		for (int i=0;i<nodeaxis-1;i++)
		{
			for (int j=0;j<nodeaxis-1;j++)
			{
				rTest[i+1][j+1]=0;
			}
		}
		for (int i=0;i<repertoireaxis-1;i++)
		{
			for (int j=0;j<repertoireaxis-1;j++)
			{
				uTest[i+1][j+1]=0;
			}
		}
		double febar=feRUT(valueofn, rTest, uTest, false, 1);
		febar=febar*(dataaxis-1)+100;
		double proxdouble;
		int proxint=0;
		boolean proxboolean=false;
		int iforr=1;
		int jforr=2;
		int bestkforr=-1;
		double bestforr=1;
		int iforu=1;
		int jforu=2;
		int bestkforu=-1;
		double bestforu=1;
		do
		{
			proxdouble=feRUT(valueofn, rTest, uTest, true, febar);
			if (proxdouble<febar)
			{
				for (int i=0;i<nodeaxis-1;i++)
				{
					for (int j=0;j<nodeaxis-1;j++)
					{
						rStore[i+1][j+1]=Double.toString(rOptionsArray[i+1][j+1][rTest[i+1][j+1]]);
					}
				}
				for (int i=0;i<repertoireaxis-1;i++)
				{
					for (int j=0;j<repertoireaxis-1;j++)
					{
						uStore[i+1][j+1]=Double.toString(uOptionsArray[i+1][j+1][uTest[i+1][j+1]]);
					}
				}
				febar=proxdouble;
				proxint=0;
			}
			else
			{
				if ((proxdouble==febar) && (proxint<10))
				{
					for (int i=0;i<nodeaxis-1;i++)
					{
						for (int j=0;j<nodeaxis-1;j++)
						{
							rStore[i+1][j+1]=(rStore[i+1][j+1]+":"+rOptionsArray[i+1][j+1][rTest[i+1][j+1]]);
						}
					}
					for (int i=0;i<repertoireaxis-1;i++)
					{
						for (int j=0;j<repertoireaxis-1;j++)
						{
							uStore[i+1][j+1]=(uStore[i+1][j+1]+":"+uOptionsArray[i+1][j+1][uTest[i+1][j+1]]);
						}
					}
					proxint++;
				}
			}
			if (proceed)
			{
				try
				{
					Thread.sleep(0);
				} 
				catch (InterruptedException e)
				{
					e.printStackTrace();
				}
			}
			else
			{
				break;
			}
			switch(radiobuttonr)
			{
			case 1:	proxboolean=generatorOneForR(1,2);
					break;
			case 2:	proxboolean=generatorTwoForR();
					break;
			case 3:	proxboolean=false;
					if (nodeaxis>2)
					{
						proxboolean=true;
						if ((proxdouble<bestforr)||(bestkforr==-1))
						{
							bestforr=proxdouble;
							bestkforr=rTest[iforr][jforr];
						}
						if (rTest[iforr][jforr]+1<rOptionsArray[iforr][jforr].length)
						{
							rTest[iforr][jforr]=rTest[iforr][jforr]+1;
							rTest[jforr][iforr]=rTest[jforr][iforr]+1;
						}
						else
						{
							rTest[iforr][jforr]=bestkforr;
							rTest[jforr][iforr]=bestkforr;
							do
							{
								if (jforr+1<nodeaxis)
								{
									jforr++;
									if (rOptionsArray[iforr][jforr].length>1)
									{
										bestkforr=0;
										rTest[iforr][jforr]=1;
										rTest[jforr][iforr]=1;
									}
								}
								else
								{
									if (iforr+1<nodeaxis-1)
									{
										iforr++;
										jforr=iforr+1;
										if (rOptionsArray[iforr][jforr].length>1)
										{
											bestkforr=0;
											rTest[iforr][jforr]=1;
											rTest[jforr][iforr]=1;
										}
									}
									else
									{
										iforr=1;
										jforr=2;
										for (int i=0;i<nodeaxis-1;i++)
										{
											for (int j=0;j<nodeaxis-1;j++)
											{
												rTest[i+1][j+1]=0;
											}
										}
										bestkforr=-1;
										proxboolean=false;
									}
								}
							} while((rOptionsArray[iforr][jforr].length<2) && proxboolean);
						}
					}
					break;
			}
			if (!proxboolean)
			{
				switch(radiobuttonu)
				{
				case 1:	proxboolean=generatorOneForU(1,2);
						break;
				case 2:	proxboolean=generatorTwoForU();
						break;
				case 3:	proxboolean=false;
						if (repertoireaxis>2)
						{
							proxboolean=true;
							if ((proxdouble<bestforu)||(bestkforu==-1))
							{
								bestforu=proxdouble;
								bestkforu=uTest[iforu][jforu];
							}
							if (uTest[iforu][jforu]+1<uOptionsArray[iforu][jforu].length)
							{
								uTest[iforu][jforu]=uTest[iforu][jforu]+1;
								uTest[jforu][iforu]=uTest[jforu][iforu]+1;
							}
							else
							{
								uTest[iforu][jforu]=bestkforu;
								uTest[jforu][iforu]=bestkforu;
								do
								{
									if (jforu+1<repertoireaxis)
									{
										jforu++;
										if (uOptionsArray[iforu][jforu].length>1)
										{
											bestkforu=0;
											uTest[iforu][jforu]=1;
											uTest[jforu][iforu]=1;
										}
									}
									else
									{
										if (iforu+1<repertoireaxis-1)
										{
											iforu++;
											jforu=iforu+1;
											if (uOptionsArray[iforu][jforu].length>1)
											{
												bestkforu=0;
												uTest[iforu][jforu]=1;
												uTest[jforu][iforu]=1;
											}
										}
										else
										{
											proxboolean=false;
										}
									}
								} while((uOptionsArray[iforu][jforu].length<2) && proxboolean);
							}
						}
						break;
				}
			}
		} while(proxboolean);
		febar=febar/((double) (dataaxis-1));
		return febar;
	}
	private boolean generatorOneForR(int iplace, int jplace)
	{
		if (iplace>nodeaxis-2)
		{
			return false;
		}
		else
		{
			if (jplace>nodeaxis-1)
			{
				return generatorOneForR(iplace+1,iplace+2);
			}
			else
			{
				if (rTest[iplace][jplace]+1>rOptionsArray[iplace][jplace].length-1)
				{
					rTest[iplace][jplace]=0;
					rTest[jplace][iplace]=0;
					return generatorOneForR(iplace,jplace+1);
				}
				else
				{
					rTest[iplace][jplace]=rTest[iplace][jplace]+1;
					rTest[jplace][iplace]=rTest[jplace][iplace]+1;
					return true;
				}
			}
		}
	}
	private boolean generatorOneForU(int iplace, int jplace)
	{
		if (iplace>repertoireaxis-2)
		{
			return false;
		}
		else
		{
			if (jplace>repertoireaxis-1)
			{
				return generatorOneForU(iplace+1,iplace+2);
			}
			else
			{
				if (uTest[iplace][jplace]+1>uOptionsArray[iplace][jplace].length-1)
				{
					uTest[iplace][jplace]=0;
					uTest[jplace][iplace]=0;
					return generatorOneForU(iplace,jplace+1);
				}
				else
				{
					uTest[iplace][jplace]=uTest[iplace][jplace]+1;
					uTest[jplace][iplace]=uTest[jplace][iplace]+1;
					return true;
				}
			}
		}
	}
	private boolean generatorTwoForR()
	{
		boolean proxbooleantwo=false;
		for (int i=1;i<nodeaxis-1;i++)
		{
			for (int j=i+1;j<nodeaxis;j++)
			{
				if (rTest[i][j]+1<rOptionsArray[i][j].length)
				{
					rTest[i][j]=rTest[i][j]+1;
					rTest[j][i]=rTest[j][i]+1;
					proxbooleantwo=true;
				}
			}
		}
		if (proxbooleantwo==false)
		{
			for (int i=0;i<nodeaxis-1;i++)
			{
				for (int j=0;j<nodeaxis-1;j++)
				{
					rTest[i+1][j+1]=0;
				}
			}
		}
		return proxbooleantwo;
	}
	private boolean generatorTwoForU()
	{
		boolean proxbooleantwo=false;
		for (int i=1;i<repertoireaxis-1;i++)
		{
			for (int j=i+1;j<repertoireaxis;j++)
			{
				if (uTest[i][j]+1<uOptionsArray[i][j].length)
				{
					uTest[i][j]=uTest[i][j]+1;
					uTest[j][i]=uTest[j][i]+1;
					proxbooleantwo=true;
				}
			}
		}
		if (proxbooleantwo==false)
		{
			for (int i=0;i<repertoireaxis-1;i++)
			{
				for (int j=0;j<repertoireaxis-1;j++)
				{
					uTest[i+1][j+1]=0;
				}
			}
		}
		return proxbooleantwo;
	}
	private double[][] feRUTrandomvariable(int thevalofn, int obsval, int entriesval)
	{
		double[][] eferanddouble = new double[obsval+1][2];
		makeobservations: for (int i=0;i<obsval;i++)
		{
			setranduOptionsArray(entriesval);
			setrandrOptionsArray(entriesval);
			if (proceed)
			{
				try
				{
					Thread.sleep(0);
				} 
				catch (InterruptedException e)
				{
					e.printStackTrace();
				}
			}
			else
			{
				break makeobservations;
			}
			eferanddouble[i+1][1]=feRUT(thevalofn, selectFirstR, selectFirstU, false, 0);
		}
		return eferanddouble;
	}
	private Object[][] toObjectArray(double[][] thearray)
	{
		Object[][] convertedarray = new Object[thearray.length][thearray[0].length];
		for (int i=0;i<thearray.length-1;i++)
		{
			for (int j=0;j<thearray[0].length-1;j++)
			{
				convertedarray[i+1][j+1]=Double.toString(Math.round(thearray[i+1][j+1]*1000000)/((double) 1000000));
			}
		}
		return convertedarray;
	}
	private Object[][] toObjectArrayNoRounding(double[][] thearray)
	{
		Object[][] convertedarray = new Object[thearray.length][thearray[0].length];
		for (int i=0;i<thearray.length-1;i++)
		{
			for (int j=0;j<thearray[0].length-1;j++)
			{
				convertedarray[i+1][j+1]=Double.toString(thearray[i+1][j+1]);
			}
		}
		return convertedarray;
	}
	private Object[][] addnodeheaders(Object[][] thearray)
	{
		for (int i=0;i<thearray.length-1;i++)
		{
			thearray[0][i+1]=("node "+(i+1));
			thearray[i+1][0]=("node "+(i+1));
		}
		return thearray;
	}
	private Object[][] addrepertoireheaders(Object[][] thearray)
	{
		if ((thearray.length==thearray[0].length) && (thearray.length==repertoireaxis))
		{
			for (int i=0;i<repertoireaxis-1;i++)
			{
				thearray[0][i+1]=uOptions.tableValAt(1, i+2);
				thearray[i+1][0]=uOptions.tableValAt(i+2, 1);
			}
		}
		return thearray;
	}
	private Object[][] addheadernumbers(Object[][] thearray)
	{
		for (int i=0;i<thearray[0].length-1;i++)
		{
			thearray[0][i+1]=(""+(i+1));
		}
		for (int i=0;i<thearray.length-1;i++)
		{
			thearray[i+1][0]=(""+(i+1));
		}
		return thearray;
	}
	private Object[][] addthetypicaldata(Object[][] thearray)
	{
		if ((thearray.length==dataaxis) && (thearray[0].length==nodeaxis+1))
		{
			for (int i=0;i<dataaxis;i++)
			{
				for (int j=0;j<nodeaxis;j++)
				{
					thearray[i][j]=(typicalData.tableValAt(i+1,j+1));
				}
			}
			thearray[0][nodeaxis]=("fe");
		}
		return thearray;
	}
	private double[][] threeDtotwoD(double[][][] thethreedarray)
	{
		double[][] thetwodarray = new double[thethreedarray.length][thethreedarray[0].length];
		for (int i=0;i<thethreedarray.length;i++)
		{
			for (int j=0;j<thethreedarray[0].length;j++)
			{
				thetwodarray[i][j]=thethreedarray[i][j][0];
			}
		}
		return thetwodarray;
	}
	private double[][] feRUSiforalli(int thevalofn, int[][] theRoptionin, int[][] theUoptionin)
	{
		double[][] efdatadouble = new double[dataaxis][nodeaxis+1];
		incertfesi: for (int i=0;i<dataaxis-1;i++)
		{
			if (proceed)
			{
				try
				{
					Thread.sleep(0);
				} 
				catch (InterruptedException e)
				{
					e.printStackTrace();
				}
			}
			else
			{
				break incertfesi;
			}
			efdatadouble[i+1][nodeaxis]=feRUSi(thevalofn, theRoptionin, theUoptionin, i+1);
		}
		return efdatadouble;
	}
	public void modeOne(int thedataindex)
	{
		while (true)
		{
		setDataArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setuOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		outputPanel.add(new ExcellOutputTable(addnodeheaders(toObjectArray(RUSi(thedataindex, selectFirstU))),440,385,("R(U_op1,S_"+thedataindex+")")));
		outputPanel.getParent().validate();
		outputPanel.getParent().repaint();
		outputPanelBar.setValue(outputPanelBar.getMaximum());
		break;
		}
	}
	public void modeTwo()
	{
		while (true)
		{
		setDataArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setuOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		outputPanel.add(new ExcellOutputTable(addnodeheaders(toObjectArray(RT(selectFirstU))),440,385,("R_T")));
		outputPanel.getParent().validate();
		outputPanel.getParent().repaint();
		outputPanelBar.setValue(outputPanelBar.getMaximum());
		break;
		}
	}
	public void modeThree(int thedataindex, int thevalueofn)
	{
		while (true)
		{
		setDataArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setuOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setrOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		if (thevalueofn==100)
		{
			outputPanel.add(new centerJLabel(("fe(R_op1,U_op1,S_"+thedataindex+")="+feRUSi(thevalueofn, selectFirstR, selectFirstU, thedataindex)+" for d_n with n=infinity")));
		}
		else
		{
			outputPanel.add(new centerJLabel(("fe(R_op1,U_op1,S_"+thedataindex+")="+feRUSi(thevalueofn, selectFirstR, selectFirstU, thedataindex)+" for d_n with n="+thevalueofn)));
		}
		outputPanel.getParent().validate();
		outputPanel.getParent().repaint();
		outputPanelBar.setValue(outputPanelBar.getMaximum());
		break;
		}
	}
	public void modeFour(int thevalueofn)
	{
		while (true)
		{
		setDataArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setuOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setrOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		if (thevalueofn==100)
		{
			outputPanel.add(new centerJLabel(("efe(R_op1,U_op1,T)="+feRUT(thevalueofn, selectFirstR, selectFirstU, false, 0)+" for d_n with n=infinity")));
		}
		else
		{
			outputPanel.add(new centerJLabel(("efe(R_op1,U_op1,T)="+feRUT(thevalueofn, selectFirstR, selectFirstU, false, 0)+" for d_n with n="+thevalueofn)));
		}
		outputPanel.getParent().validate();
		outputPanel.getParent().repaint();
		outputPanelBar.setValue(outputPanelBar.getMaximum());
		break;
		}
	}
	public void modeFive(int thedataindex, int thevalueofn)
	{
		while (true)
		{
		setDataArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setuOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setrOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		if (thevalueofn==100)
		{
			outputPanel.add(new centerJLabel(("d_infinity(R_op1,R(U_op1,S_"+thedataindex+"))="+dnMetric(thevalueofn, selectFirstR, RUSi(thedataindex, selectFirstU), true))));
		}
		else
		{
			outputPanel.add(new centerJLabel(("d_"+thevalueofn+"(R_op1,R(U_op1,S_"+thedataindex+"))="+dnMetric(thevalueofn, selectFirstR, RUSi(thedataindex, selectFirstU), true))));
		}
		outputPanel.getParent().validate();
		outputPanel.getParent().repaint();
		outputPanelBar.setValue(outputPanelBar.getMaximum());
		break;
		}
	}
	public void modeSix(int thevanueofn)
	{
		while (true)
		{
		setDataArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setuOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setrOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		if (thevanueofn==100)
		{
			outputPanel.add(new centerJLabel(("d_infinity(R_op1,U_op1,T)="+dnRUT(thevanueofn, selectFirstR, selectFirstU))));
		}
		else
		{
			outputPanel.add(new centerJLabel(("d_"+thevanueofn+"(R_op1,U_op1,T)="+dnRUT(thevanueofn, selectFirstR, selectFirstU))));
		}
		outputPanel.getParent().validate();
		outputPanel.getParent().repaint();
		outputPanelBar.setValue(outputPanelBar.getMaximum());
		break;
		}
	}
	public void modeSeven(int thevalueofn, int radiobuttonr, int radiobuttonu)
	{
		while (true)
		{
		setDataArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setuOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setrOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		outputPanel.add(new centerJLabel("------------- Approximation of U and R -------------"));
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		if (thevalueofn==100)
		{
			outputPanel.add(new centerJLabel(("efe(R_approx,U_approx,T)="+approximateUR(thevalueofn, radiobuttonr, radiobuttonu)+" for d_n with n=infinity")));
		}
		else
		{
			outputPanel.add(new centerJLabel(("efe(R_approx,U_approx,T)="+approximateUR(thevalueofn, radiobuttonr, radiobuttonu)+" for d_n with n="+thevalueofn)));
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		outputPanel.add(new ExcellOutputTable(addrepertoireheaders(uStore),440,385,("Approximations of U")));
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		outputPanel.add(new ExcellOutputTable(addnodeheaders(rStore),440,385,("Approximations of R")));
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		outputPanel.add(new centerJLabel("---------------------------------------------------------------------------"));
		outputPanel.getParent().validate();
		outputPanel.getParent().repaint();
		outputPanelBar.setValue(outputPanelBar.getMaximum());
		break;
		}
	}
	public void modeEight(int thevalueofn, int observsvalue, int entriesresvalue)
	{
		while (true)
		{
		setDataArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		outputPanel.add(new centerJLabel((observsvalue + " observations of efe(R_random,U_random,T) with")));
		if (entriesresvalue==-1)
		{
			outputPanel.add(new centerJLabel(("each entry in R_random and U_random a random double in [0,1),")));
		}
		else
		{
			outputPanel.add(new centerJLabel((entriesresvalue + " possibilities per entry in R_random and U_random,")));
		}
		if (thevalueofn==100)
		{
			outputPanel.add(new centerJLabel(("and d_n with n=infinity")));
		}
		else
		{
			outputPanel.add(new centerJLabel(("and d_n with n="+thevalueofn)));
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		outputPanel.add(new ExcellOutputTable(addheadernumbers(toObjectArrayNoRounding(feRUTrandomvariable(thevalueofn, observsvalue, entriesresvalue))),440,385,("efe(R_random,U_random,T)")));
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		outputPanel.add(new ExcellOutputTable(addrepertoireheaders(toObjectArrayNoRounding(threeDtotwoD(uOptionsArray))),440,385,("Example of U_random")));
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		outputPanel.add(new ExcellOutputTable(addnodeheaders(toObjectArrayNoRounding(threeDtotwoD(rOptionsArray))),440,385,("Example of R_random")));
		outputPanel.getParent().validate();
		outputPanel.getParent().repaint();
		outputPanelBar.setValue(outputPanelBar.getMaximum());
		break;
		}
	}
	public void modeNine(int thevalueofn)
	{
		while (true)
		{
		setDataArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setuOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		setrOptionsArray();
		if (proceed)
		{
			try
			{
				Thread.sleep(0);
			} 
			catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		else
		{
			break;
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		if (thevalueofn==100)
		{
			outputPanel.add(new centerJLabel(("fe(R_op1,U_op1,S_i) for all i and for d_n with n=infinity")));
		}
		else
		{
			outputPanel.add(new centerJLabel(("fe(R_op1,U_op1,S_i) for all i and for d_n with n="+thevalueofn)));
		}
		outputPanel.add(new Box.Filler(spacebox4, spacebox4, spacebox4));
		outputPanel.add(new ExcellOutputTable(addthetypicaldata(toObjectArrayNoRounding(feRUSiforalli(thevalueofn, selectFirstR, selectFirstU))),440,385,("fe(R_op1,U_op1,S_i)")));
		outputPanel.getParent().validate();
		outputPanel.getParent().repaint();
		outputPanelBar.setValue(outputPanelBar.getMaximum());
		break;
		}
	}
}

class ExcellOutputTable extends JPanel
{
int numcols;
Object[][] data;
String settitle;
JTable jTable1;
private static final long serialVersionUID = 9708986778989L;
public ExcellOutputTable(Object[][] thearray, int portwidth, int portheight, String thetitle)
{
   super();
   try
   {
	  data = new Object[thearray.length][thearray[0].length];
	  data=thearray;
	  settitle = new String();
	  settitle=thetitle;
	  numcols=data[0].length; 
      jbInit(portwidth, portheight);
   }
   catch (Exception e)
   {
      e.printStackTrace();
   }
}
private void jbInit(int viewportwidth, int viewportheight) throws Exception
{
Object[] header=new Object[numcols];
for (int i=0;i<numcols;i++)
{
	header[i]=new Integer(i);
}
jTable1=new JTable(data,header);
jTable1.setCellSelectionEnabled(true);
jTable1.setBackground(Color.white);
jTable1.setPreferredScrollableViewportSize(new Dimension(viewportwidth, viewportheight));
JScrollPane scrollPane = new JScrollPane(jTable1, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
for (int i=0;i<numcols;i++)
{
	jTable1.getColumnModel().getColumn(i).setMaxWidth(55);
}
jTable1.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
scrollPane.getViewport().setBackground(Color.white);
this.add(scrollPane, BorderLayout.CENTER);
this.setMaximumSize(new Dimension(viewportwidth+40, viewportheight+90));
this.setBackground(new Color(255,250,235));
this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), settitle, TitledBorder.CENTER, TitledBorder.TOP));
// This is the line that does all the magic!
@SuppressWarnings("unused")
ExcelAdapter myAd = new ExcelAdapter(jTable1);
}
}